/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java.types;

import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.types.DataType;
import com.snowflake.snowpark_java.types.StructField;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import scala.Option;

public class StructType
extends DataType
implements Iterable<StructField> {
    private final com.snowflake.snowpark.types.StructType scalaStructType;

    StructType(com.snowflake.snowpark.types.StructType structType) {
        this.scalaStructType = structType;
    }

    public StructType(StructType other) {
        this(other.scalaStructType);
    }

    public StructType(StructField[] fields) {
        this(new com.snowflake.snowpark.types.StructType(StructType.toScalaFieldsArray(fields)));
    }

    public static StructType create(StructField ... fields) {
        return new StructType(fields);
    }

    private static com.snowflake.snowpark.types.StructField[] toScalaFieldsArray(StructField[] fields) {
        com.snowflake.snowpark.types.StructField[] result = new com.snowflake.snowpark.types.StructField[fields.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = fields[i].toScalaStructField();
        }
        return result;
    }

    public int fieldIndex(String fieldName) {
        return this.scalaStructType.fieldIndex(fieldName);
    }

    public String[] names() {
        return JavaUtils.seqToJavaStringArray(this.scalaStructType.names());
    }

    public int size() {
        return this.scalaStructType.size();
    }

    @Override
    public Iterator<StructField> iterator() {
        return new Iterator<StructField>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return StructType.this.scalaStructType.size() > this.index;
            }

            @Override
            public StructField next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Index: " + this.index + " iterator size: " + StructType.this.scalaStructType.size());
                }
                return new StructField(StructType.this.scalaStructType.apply(this.index++));
            }
        };
    }

    public StructField get(int index) {
        return new StructField(this.scalaStructType.apply(index));
    }

    @Override
    public String toString() {
        return this.scalaStructType.toString();
    }

    public StructType add(StructField field) {
        return new StructType(this.scalaStructType.add(field.toScalaStructField()));
    }

    public StructType add(String name, DataType dataType, boolean nullable) {
        return this.add(new StructField(name, dataType, nullable));
    }

    public StructType add(String name, DataType dataType) {
        return this.add(name, dataType, true);
    }

    public Optional<StructField> nameToField(String name) {
        Option<com.snowflake.snowpark.types.StructField> fields = this.scalaStructType.nameToField(name);
        return fields.isEmpty() ? Optional.empty() : Optional.of(new StructField((com.snowflake.snowpark.types.StructField)fields.get()));
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof StructType) {
            return this.scalaStructType.equals(((StructType)other).scalaStructType);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.scalaStructType.hashCode();
    }

    public void printTreeString() {
        this.scalaStructType.printTreeString();
    }

    com.snowflake.snowpark.types.StructType getScalaStructType() {
        return this.scalaStructType;
    }
}

