/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.snowflake.snowpark.Column;
import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.SnowparkSFConnectionHandler$;
import com.snowflake.snowpark.internal.Utils;
import com.snowflake.snowpark.internal.analyzer.Attribute;
import com.snowflake.snowpark.internal.analyzer.Attribute$;
import com.snowflake.snowpark.internal.analyzer.Expression;
import com.snowflake.snowpark.internal.analyzer.LogicalPlan;
import com.snowflake.snowpark.internal.analyzer.TableFunctionExpression;
import com.snowflake.snowpark.internal.analyzer.package$;
import com.snowflake.snowpark.udtf.UDTF;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;
import scala.util.Random;
import scala.util.Random$;
import scala.util.matching.Regex;

public final class Utils$
extends Logging {
    public static Utils$ MODULE$;
    private String OSName;
    private boolean isWindows;
    private String ScalaVersion;
    private String JavaVersion;
    private String clientPackageName;
    private final String Version;
    private final String SnowparkPackageName;
    private final String PackageNameDelimiter;
    private final String ScalaCompatVersion;
    private final String ScalaMinimumMinorVersion;
    private final String MinimumGSVersionForSnowparkClientType;
    private final String DateInputFormat;
    private final String TimestampInputFormat;
    private final String TempObjectNamePattern;
    private final List<String> SnowflakePathPrefixes;
    private final Random randomGenerator;
    private final String _TEMP_OBJECT_PREFIX;
    private final int RETRY_SLEEP_TIME_UNIT_IN_MS;
    private final int MAX_SLEEP_TIME_IN_MS;
    private final ObjectMapper objectMapper;
    private volatile byte bitmap$0;

    static {
        new Utils$();
    }

    public String Version() {
        return this.Version;
    }

    public String SnowparkPackageName() {
        return this.SnowparkPackageName;
    }

    public String PackageNameDelimiter() {
        return this.PackageNameDelimiter;
    }

    public String ScalaCompatVersion() {
        return this.ScalaCompatVersion;
    }

    public String ScalaMinimumMinorVersion() {
        return this.ScalaMinimumMinorVersion;
    }

    public String MinimumGSVersionForSnowparkClientType() {
        return this.MinimumGSVersionForSnowparkClientType;
    }

    public String DateInputFormat() {
        return this.DateInputFormat;
    }

    public String TimestampInputFormat() {
        return this.TimestampInputFormat;
    }

    public String TempObjectNamePattern() {
        return this.TempObjectNamePattern;
    }

    public List<String> SnowflakePathPrefixes() {
        return this.SnowflakePathPrefixes;
    }

    public Random randomGenerator() {
        return this.randomGenerator;
    }

    private final String _TEMP_OBJECT_PREFIX() {
        return this._TEMP_OBJECT_PREFIX;
    }

    public String convertWindowsPathToLinux(String path) {
        return path.replace("\\", "/");
    }

    public String convertPathIfNecessary(String path) {
        if (this.isWindows()) {
            return this.convertWindowsPathToLinux(path);
        }
        return path;
    }

    private String OSName$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.OSName = System.getProperty("os.name");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.OSName;
    }

    public String OSName() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.OSName$lzycompute();
        }
        return this.OSName;
    }

    private boolean isWindows$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.isWindows = this.OSName().toLowerCase(Locale.ENGLISH).contains("win");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.isWindows;
    }

    public boolean isWindows() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.isWindows$lzycompute();
        }
        return this.isWindows;
    }

    private String ScalaVersion$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.ScalaVersion = Properties$.MODULE$.versionNumberString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.ScalaVersion;
    }

    public String ScalaVersion() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.ScalaVersion$lzycompute();
        }
        return this.ScalaVersion;
    }

    private String JavaVersion$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.JavaVersion = System.getProperty("java.version");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.JavaVersion;
    }

    public String JavaVersion() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.JavaVersion$lzycompute();
        }
        return this.JavaVersion;
    }

    public boolean isSnowparkJar(String path) {
        String fileName = ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).last()).toLowerCase(Locale.ROOT);
        return fileName.startsWith("snowpark") && (fileName.endsWith(".jar") || fileName.endsWith(".jar.gz"));
    }

    public String getUserCodeMeta() {
        ObjectRef lastInternalLine = ObjectRef.create((Object)"<unknown>");
        BooleanRef internalCode = BooleanRef.create((boolean)true);
        ArrayBuffer stackTrace = new ArrayBuffer();
        int stackDepth = 3;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace())).foreach((Function1 & Serializable & scala.Serializable)ste -> {
            Utils$.$anonfun$getUserCodeMeta$1(internalCode, lastInternalLine, stackTrace, ste);
            return BoxedUnit.UNIT;
        });
        return new StringBuilder(1).append((String)lastInternalLine.elem).append("\n").append(((TraversableOnce)stackTrace.take(stackDepth)).mkString("\n")).toString();
    }

    public scala.collection.immutable.Map<String, Seq<Attribute>> addToDataframeAliasMap(scala.collection.immutable.Map<String, Seq<Attribute>> result, LogicalPlan child) {
        if (child != null) {
            scala.collection.immutable.Map<String, Seq<Attribute>> map = child.dfAliasMap();
            scala.collection.immutable.Set duplicatedAlias = (scala.collection.immutable.Set)result.keySet().intersect((GenSet)map.keySet());
            if (duplicatedAlias.nonEmpty()) {
                throw ErrorMessage$.MODULE$.DF_ALIAS_DUPLICATES((Set<String>)duplicatedAlias);
            }
            return result.$plus$plus(map);
        }
        return result;
    }

    public <T> T logTime(Function0<T> f, String funcDescription) {
        this.logInfo(funcDescription);
        long start = System.currentTimeMillis();
        Object ret = f.apply();
        long end = System.currentTimeMillis();
        this.logInfo(new StringBuilder(16).append("Finished ").append(funcDescription).append(" in ").append(end - start).append(" ms").toString());
        return (T)ret;
    }

    public Option<Class<?>> getContainingClass(Object closure) {
        None$ none$;
        block3: {
            try {
                Object object = closure;
                if (object instanceof UDTF) {
                    UDTF uDTF = (UDTF)object;
                    none$ = new Some(uDTF.getClass());
                    break block3;
                }
                Method writeReplace = closure.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                writeReplace.setAccessible(true);
                SerializedLambda lambda = (SerializedLambda)writeReplace.invoke(closure, new Object[0]);
                String className = lambda.getCapturingClass().replaceAll("/", ".");
                none$ = new Some(Class.forName(className));
            }
            catch (Exception e) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public String normalizeStageLocation(String name) {
        String trimName = name.trim();
        if (this.SnowflakePathPrefixes().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)trimName.startsWith(x$1)))) {
            return trimName;
        }
        return new StringBuilder(1).append("@").append(trimName).toString();
    }

    private boolean isSingleQuoted(String name) {
        return name.startsWith("'") && name.endsWith("'");
    }

    public String normalizeLocalFile(String file) {
        String trimFile = file.trim();
        if (trimFile.startsWith("file://") || this.isSingleQuoted(trimFile)) {
            return trimFile;
        }
        return new StringBuilder(7).append("file://").append(trimFile).toString();
    }

    public String calculateMD5(File file) {
        byte[] buffer = new byte[8192];
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        try (DigestInputStream dis = new DigestInputStream(new FileInputStream(file), md5);){
            while (dis.read(buffer) != -1) {
            }
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(md5.digest())).map((Function1 & Serializable & scala.Serializable)x$2 -> Utils$.$anonfun$calculateMD5$1(BoxesRunTime.unboxToByte((Object)x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
    }

    public String checkUDFStage(String normalized) {
        if (!normalized.endsWith("/")) {
            return new StringBuilder(1).append(normalized).append("/").toString();
        }
        return normalized;
    }

    public int stageFilePrefixLength(String stageLocation) {
        String normalized = this.checkUDFStage(this.normalizeStageLocation(stageLocation));
        if (normalized.startsWith("@~")) {
            return normalized.length() - 3;
        }
        IntRef res = IntRef.create((int)0);
        BooleanRef isQuoted = BooleanRef.create((boolean)false);
        ((IterableLike)new StringOps(Predef$.MODULE$.augmentString(normalized)).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Utils$.$anonfun$stageFilePrefixLength$1(isQuoted, res, normalized, x0$1);
            return BoxedUnit.UNIT;
        });
        return res.elem;
    }

    public Tuple3<String, String, String> parseStageFileLocation(String stageLocation) {
        Object object = new Object();
        try {
            String normalized = this.normalizeStageLocation(stageLocation);
            if (stageLocation.endsWith("/")) {
                throw ErrorMessage$.MODULE$.MISC_INVALID_STAGE_LOCATION(stageLocation, "Stage file location must point to a file, not a folder");
            }
            BooleanRef isQuoted = BooleanRef.create((boolean)false);
            ((IterableLike)new StringOps(Predef$.MODULE$.augmentString(normalized)).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Utils$.$anonfun$parseStageFileLocation$1(isQuoted, normalized, stageLocation, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw ErrorMessage$.MODULE$.MISC_INVALID_STAGE_LOCATION(stageLocation, "Missing '/' to separate stage name and file name");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple3)ex.value();
        }
    }

    public void checkScalaVersionCompatibility() {
        this.checkScalaVersionCompatibility(this.ScalaVersion());
    }

    public void checkScalaVersionCompatibility(String inputScalaVersion) {
        if (!inputScalaVersion.startsWith(this.ScalaCompatVersion()) || this.compareVersion(inputScalaVersion, this.ScalaMinimumMinorVersion()) < 0) {
            throw ErrorMessage$.MODULE$.MISC_SCALA_VERSION_NOT_SUPPORTED(inputScalaVersion, this.ScalaCompatVersion(), this.ScalaMinimumMinorVersion());
        }
    }

    public int compareVersion(String version1, String version2) {
        return BoxesRunTime.unboxToInt((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])version1.split("\\."))).zipAll((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])version2.split("\\.")), (Object)"0", (Object)"0", Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$compareVersion$1(x0$1))).fold((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, (Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$compareVersion$3(x0$2))));
    }

    public void validateObjectName(String name) {
        String unQuotedIdPattern = "([a-zA-Z_][\\w$]*)";
        String quotedIdPattern = "(\"([^\"]|\"\")+\")";
        String idPattern = new StringBuilder(3).append("(").append(unQuotedIdPattern).append("|").append(quotedIdPattern).append(")").toString();
        String pattern = new StringBuilder(20).append("^((").append(idPattern).append("\\.){0,2}|(").append(idPattern).append("\\.\\.))").append(idPattern).append("$").toString();
        if (!name.matches(pattern)) {
            throw ErrorMessage$.MODULE$.MISC_INVALID_OBJECT_NAME(name);
        }
    }

    public boolean isValidJavaIdentifier(String name) {
        return name.length() > 0 && Character.isJavaIdentifierStart(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(name)).head())) && ((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(name)).drop(1))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$isValidJavaIdentifier$1(BoxesRunTime.unboxToChar((Object)x$3))))).isEmpty();
    }

    public String getUDFUploadPrefix(String udfName) {
        if (udfName.matches("[\\w]+")) {
            return udfName;
        }
        return new StringBuilder(1).append(udfName.replaceAll("\\W", "")).append("_").append(RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(udfName.hashCode()))).toString();
    }

    public <T> scala.collection.mutable.Set<T> createConcurrentSet() {
        return (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(Collections.newSetFromMap(new ConcurrentHashMap())).asScala();
    }

    public String randomNameForTempObject(Utils.TempObjectType tempObjectType) {
        String typeStr = tempObjectType.toString().replaceAll("\\s", "_").toUpperCase();
        String randStr = this.randomGenerator().alphanumeric().take(15).mkString().toUpperCase();
        String name = new StringBuilder(2).append(this._TEMP_OBJECT_PREFIX()).append("_").append(typeStr).append("_").append(randStr).toString();
        Predef$.MODULE$.assert(name.matches(this.TempObjectNamePattern()), (Function0 & Serializable & scala.Serializable)() -> "Generated temp object name does not match the required pattern");
        return name;
    }

    public String escapePath(String path) {
        if (this.isWindows()) {
            return path.replace("\\", "\\\\");
        }
        return path;
    }

    private int RETRY_SLEEP_TIME_UNIT_IN_MS() {
        return this.RETRY_SLEEP_TIME_UNIT_IN_MS;
    }

    private int MAX_SLEEP_TIME_IN_MS() {
        return this.MAX_SLEEP_TIME_IN_MS;
    }

    public int retrySleepTimeInMS(int retry) {
        int expectedTime = this.RETRY_SLEEP_TIME_UNIT_IN_MS() * (int)Math.pow(2.0, retry);
        expectedTime = Math.min(expectedTime, this.MAX_SLEEP_TIME_IN_MS());
        expectedTime = expectedTime / 2 + RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt(expectedTime / 2)));
        return expectedTime;
    }

    public boolean isRetryable(Throwable t) {
        SnowflakeSQLException snowflakeSQLException;
        Throwable throwable = t;
        return throwable instanceof SnowflakeSQLException && ((snowflakeSQLException = (SnowflakeSQLException)throwable).getMessage().contains("JDBC driver internal error") || snowflakeSQLException.getMessage().contains("JDBC driver encountered IO error"));
    }

    public <T> void withRetry(int maxRetry, String logPrefix, Function0<T> thunk) {
        int retry = 0;
        boolean done = false;
        None$ lastError = None$.MODULE$;
        while (retry < maxRetry && !done) {
            try {
                thunk.apply();
                done = true;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && this.isRetryable(throwable2 = throwable3)) {
                    this.logError(new StringBuilder(59).append("withRetry() failed: ").append(logPrefix).append(", sleep ").append(this.retrySleepTimeInMS(retry)).append(" ms").append(" and retry: ").append(retry).append(" error message: ").append(throwable2.getMessage()).toString());
                    Thread.sleep(this.retrySleepTimeInMS(retry));
                    lastError = new Some((Object)throwable2);
                    ++retry;
                    continue;
                }
                if (throwable3 != null) {
                    Throwable throwable4 = throwable3;
                    this.logError(new StringBuilder(82).append("withRetry() failed: ").append(logPrefix).append(", but don't retry because it is not retryable,").append(" error message: ").append(throwable4.getMessage()).toString());
                    throw throwable4;
                }
                throw throwable;
            }
        }
        if (!done && lastError.nonEmpty()) {
            throw (Throwable)lastError.get();
        }
    }

    public boolean isPutOrGetCommand(String sql) {
        if (sql != null) {
            String adjustSql = sql.trim().toLowerCase(Locale.ENGLISH);
            return adjustSql.startsWith("put") || adjustSql.startsWith("get");
        }
        return false;
    }

    public boolean isStringEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private String clientPackageName$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.clientPackageName = new StringBuilder(0).append(this.SnowparkPackageName()).append(this.PackageNameDelimiter()).append(SnowparkSFConnectionHandler$.MODULE$.extractValidVersionNumber(this.Version())).toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.clientPackageName;
    }

    public String clientPackageName() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.clientPackageName$lzycompute();
        }
        return this.clientPackageName;
    }

    public String quoteForOption(Object v) {
        String string;
        Object object = v;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return Boolean.toString(bl);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return Integer.toString(n);
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n.toString();
        }
        if (object instanceof String && ((string = (String)object).equalsIgnoreCase("true") || string.equalsIgnoreCase("false"))) {
            return string;
        }
        return package$.MODULE$.singleQuote(v.toString());
    }

    public Seq<Attribute> getDisplayColumnNames(Seq<Attribute> attrs, scala.collection.immutable.Map<String, String> renamedColumns) {
        return (Seq)attrs.map((Function1 & Serializable & scala.Serializable)att -> (Attribute)renamedColumns.get((Object)att.name()).map((Function1 & Serializable & scala.Serializable)newName -> Attribute$.MODULE$.apply((String)newName, att.dataType(), att.nullable(), att.exprId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> att), Seq$.MODULE$.canBuildFrom());
    }

    public TableFunctionExpression getTableFunctionExpression(Column col) {
        Expression expression = col.expr();
        if (expression instanceof TableFunctionExpression) {
            TableFunctionExpression tableFunctionExpression = (TableFunctionExpression)expression;
            return tableFunctionExpression;
        }
        throw ErrorMessage$.MODULE$.DF_JOIN_WITH_WRONG_ARGUMENT();
    }

    private ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public Option<scala.collection.immutable.Map<String, Object>> jsonToMap(String jsonString) {
        None$ none$;
        try {
            JsonNode node = this.objectMapper().readTree(jsonString);
            JsonNodeType jsonNodeType = node.getNodeType();
            JsonNodeType jsonNodeType2 = JsonNodeType.OBJECT;
            Predef$.MODULE$.assert(!(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType2) : jsonNodeType2 != null));
            none$ = new Some((Object)((scala.collection.immutable.Map)this.jsonToScala(node)));
        }
        catch (Exception ex) {
            this.logError(ex.getMessage());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Object jsonToScala(JsonNode node) {
        JsonNodeType jsonNodeType = node.getNodeType();
        if (JsonNodeType.STRING.equals(jsonNodeType)) {
            return node.asText();
        }
        if (JsonNodeType.NULL.equals(jsonNodeType)) {
            return null;
        }
        if (JsonNodeType.OBJECT.equals(jsonNodeType)) {
            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node.fields()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry.getKey()), MODULE$.jsonToScala((JsonNode)entry.getValue()))).toMap(Predef$.MODULE$.$conforms());
        }
        if (JsonNodeType.ARRAY.equals(jsonNodeType)) {
            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node.elements()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> MODULE$.jsonToScala((JsonNode)entry)).toSeq();
        }
        if (JsonNodeType.BOOLEAN.equals(jsonNodeType)) {
            return BoxesRunTime.boxToBoolean((boolean)node.asBoolean());
        }
        if (JsonNodeType.NUMBER.equals(jsonNodeType)) {
            return node.numberValue();
        }
        throw new UnsupportedOperationException(new StringBuilder(18).append("Unsupported Type: ").append(jsonNodeType.name()).toString());
    }

    public Option<String> mapToJson(scala.collection.immutable.Map<String, Object> map) {
        Some some;
        try {
            some = new Some((Object)this.scalaToJson(map));
        }
        catch (Exception ex) {
            this.logError(ex.getMessage());
            some = None$.MODULE$;
        }
        return some;
    }

    private String scalaToJson(Object input2) {
        while (true) {
            scala.collection.immutable.Map map;
            if ((map = input2) == null) {
                return "null";
            }
            if (map instanceof String) {
                String string = (String)map;
                return new StringBuilder(2).append("\"").append(string).append("\"").toString();
            }
            if (map instanceof Integer ? true : (map instanceof Short ? true : (map instanceof Long ? true : (map instanceof Byte ? true : (map instanceof Double ? true : (map instanceof Float ? true : map instanceof Boolean)))))) {
                return input2.toString();
            }
            if (map instanceof scala.collection.immutable.Map) {
                scala.collection.immutable.Map map2 = map;
                return ((TraversableOnce)map2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        Object value = tuple2._2();
                        return new StringBuilder(1).append(MODULE$.scalaToJson(key)).append(":").append(MODULE$.scalaToJson(value)).toString();
                    }
                    throw new MatchError((Object)tuple2);
                }, Iterable$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
            }
            if (map instanceof Seq) {
                Seq seq = (Seq)map;
                return ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)input -> MODULE$.scalaToJson(input), Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
            }
            if (ScalaRunTime$.MODULE$.isArray((Object)map, 1)) {
                scala.collection.immutable.Map map3 = map;
                input2 = Predef$.MODULE$.genericArrayOps((Object)map3).toSeq();
                continue;
            }
            if (map instanceof java.util.List) {
                java.util.List list = (java.util.List)map;
                input2 = list.toArray();
                continue;
            }
            if (!(map instanceof Map)) break;
            Map map4 = (Map)map;
            input2 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(map4).asScala()).toMap(Predef$.MODULE$.$conforms());
        }
        throw new UnsupportedOperationException(new StringBuilder(18).append("Unsupported Type: ").append(input2.getClass().getName()).toString());
    }

    public static final /* synthetic */ void $anonfun$getUserCodeMeta$1(BooleanRef internalCode$1, ObjectRef lastInternalLine$1, ArrayBuffer stackTrace$1, StackTraceElement ste) {
        if (ste != null && ste.getMethodName() != null && !ste.getMethodName().contains("getStackTrace")) {
            if (internalCode$1.elem) {
                if (ste.getClassName().startsWith("net.snowflake.client.") || ste.getClassName().startsWith("com.snowflake.snowpark.") || ste.getClassName().startsWith("scala.")) {
                    lastInternalLine$1.elem = new StringBuilder(1).append(ste.getClassName()).append(".").append(ste.getMethodName()).toString();
                    return;
                }
                stackTrace$1.$plus$eq((Object)ste.toString().replaceAll("(\\$\\$iw)+", "\\$iw"));
                internalCode$1.elem = false;
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$calculateMD5$1(byte x$2) {
        return new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$2)}));
    }

    public static final /* synthetic */ void $anonfun$stageFilePrefixLength$1(BooleanRef isQuoted$1, IntRef res$1, String normalized$1, Tuple2 x0$1) {
        char c;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && '\"' == (c = tuple2._1$mcC$sp())) {
            isQuoted$1.elem = !isQuoted$1.elem;
            return;
        }
        if (tuple2 != null) {
            char c2 = tuple2._1$mcC$sp();
            int i = tuple2._2$mcI$sp();
            if ('/' == c2) {
                if (!isQuoted$1.elem && res$1.elem == 0) {
                    String fullStageName = normalized$1.substring(0, i);
                    String path = normalized$1.substring(i + 1);
                    Regex stageNamePattern = new StringOps(Predef$.MODULE$.augmentString("%?[A-Za-z0-9_$]+|\"([^\"]|\"\")+\"")).r();
                    String stageName = (String)stageNamePattern.findAllIn((CharSequence)fullStageName).toSeq().last();
                    if (stageName.startsWith("%")) {
                        res$1.elem = path.length();
                        return;
                    }
                    res$1.elem = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(stageName)).stripSuffix("\""))).stripPrefix("\"").length() + path.length() + 1;
                    return;
                }
                return;
            }
        }
        if (tuple2 != null) {
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$parseStageFileLocation$1(BooleanRef isQuoted$2, String normalized$2, String stageLocation$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        char c;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && '\"' == (c = tuple2._1$mcC$sp())) {
            isQuoted$2.elem = !isQuoted$2.elem;
            return;
        }
        if (tuple2 != null) {
            char c2 = tuple2._1$mcC$sp();
            int i = tuple2._2$mcI$sp();
            if ('/' == c2) {
                if (!isQuoted$2.elem) {
                    String fullStageName = normalized$2.substring(0, i);
                    String pathAndFileName = normalized$2.substring(i + 1);
                    if (pathAndFileName.isEmpty()) {
                        throw ErrorMessage$.MODULE$.MISC_INVALID_STAGE_LOCATION(stageLocation$1, "Missing file name after the stage name");
                    }
                    String[] pathList = pathAndFileName.split("/");
                    String path = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathList)).take(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathList)).size() - 1))).mkString("/");
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Tuple3((Object)fullStageName, (Object)path, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathList)).last()));
                }
                return;
            }
        }
        if (tuple2 != null) {
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$compareVersion$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String a = (String)tuple2._1();
            String b = (String)tuple2._2();
            String string = a;
            String string2 = b;
            return string == null ? string2 != null : !string.equals(string2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$compareVersion$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String a = (String)tuple2._1();
            String b = (String)tuple2._2();
            return new StringOps(Predef$.MODULE$.augmentString(a)).toInt() - new StringOps(Predef$.MODULE$.augmentString(b)).toInt();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isValidJavaIdentifier$1(char x$3) {
        return !Character.isJavaIdentifierPart(x$3);
    }

    private Utils$() {
        MODULE$ = this;
        this.Version = "1.16.0";
        this.SnowparkPackageName = "com.snowflake:snowpark";
        this.PackageNameDelimiter = ":";
        this.ScalaCompatVersion = "2.12";
        this.ScalaMinimumMinorVersion = "2.12.9";
        this.MinimumGSVersionForSnowparkClientType = "5.20.0";
        this.DateInputFormat = "YYYY-MM-DD";
        this.TimestampInputFormat = "YYYY-MM-DD HH24:MI:SS.FF";
        this.TempObjectNamePattern = "^SNOWPARK_TEMP_(TABLE|VIEW|STAGE|FUNCTION|TABLE_FUNCTION|FILE_FORMAT|PROCEDURE)_[0-9A-Z]+$";
        this.SnowflakePathPrefixes = new .colon.colon((Object)"@", (List)new .colon.colon((Object)"snow://", (List)new .colon.colon((Object)"/", (List)Nil$.MODULE$)));
        this.randomGenerator = new Random(System.nanoTime());
        this._TEMP_OBJECT_PREFIX = "SNOWPARK_TEMP";
        this.RETRY_SLEEP_TIME_UNIT_IN_MS = 1500;
        this.MAX_SLEEP_TIME_IN_MS = 60000;
        this.objectMapper = new ObjectMapper();
    }
}

