/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.UDFClassPath;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLClassLoader;
import java.security.CodeSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import sun.net.www.ParseUtil;

public final class UDFClassPath$
extends Logging {
    public static UDFClassPath$ MODULE$;
    private final Class<Session> snowparkClass;
    private final UDFClassPath.RequiredLibrary snowparkJar;
    private final Class<JsonNode> jacksonDatabindClass;
    private final Class<TreeNode> jacksonCoreClass;
    private final Class<JsonView> jacksonAnnotationClass;
    private final Seq<UDFClassPath.RequiredLibrary> jacksonJarSeq;
    private final Seq<UDFClassPath.RequiredLibrary> classpath;

    static {
        new UDFClassPath$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", (Ljava/lang/String;)Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("checkClass", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public Class<Session> snowparkClass() {
        return this.snowparkClass;
    }

    public UDFClassPath.RequiredLibrary snowparkJar() {
        return this.snowparkJar;
    }

    public Class<JsonNode> jacksonDatabindClass() {
        return this.jacksonDatabindClass;
    }

    public Class<TreeNode> jacksonCoreClass() {
        return this.jacksonCoreClass;
    }

    public Class<JsonView> jacksonAnnotationClass() {
        return this.jacksonAnnotationClass;
    }

    public Seq<UDFClassPath.RequiredLibrary> jacksonJarSeq() {
        return this.jacksonJarSeq;
    }

    public Seq<UDFClassPath.RequiredLibrary> classpath() {
        return this.classpath;
    }

    public Set<File> classDirs(Session session) {
        Set<URI> allURIs = session.getLocalFileDependencies();
        return (Set)((TraversableLike)allURIs.map((Function1 & Serializable & scala.Serializable)x$1 -> new File((URI)x$1), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDirectory()));
    }

    public boolean isClassDefined(Seq<URI> uris, String className) {
        boolean bl;
        URLClassLoader checkClassLoader = new URLClassLoader(uris){

            public Class<?> checkClass(String name) {
                return this.findClass(name);
            }
        };
        try {
            Object object;
            URLClassLoader qual1 = checkClassLoader;
            try {
                object = UDFClassPath$.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, className);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            Class cfr_ignored_0 = (Class)object;
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    public Option<String> getPathForClass(Class<?> clazz) {
        Option<String> path = this.getPathUsingClassLoader(clazz);
        return path.isDefined() ? path : this.getPathUsingCodeSource(clazz);
    }

    public Option<String> getPathUsingClassLoader(Class<?> clazz) {
        String classFileName = new StringBuilder(7).append("/").append(clazz.getName().replace('.', '/')).append(".class").toString();
        return Option$.MODULE$.apply((Object)clazz.getResource(classFileName)).map((Function1 & Serializable & scala.Serializable)url -> {
            String path = url.getPath().replaceAll(classFileName, "");
            if (path.contains("!")) {
                path = path.substring(0, path.indexOf("!"));
            }
            if (path.contains(":")) {
                path = path.substring(path.indexOf(":") + 1);
            }
            path = ParseUtil.decode(path);
            return new File(path).getPath();
        });
    }

    /*
     * WARNING - void declaration
     */
    public Option<String> getPathUsingCodeSource(Class<?> clazz) {
        void var3_4;
        None$ none$;
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null && codeSource.getLocation() != null) {
            String parsed = ParseUtil.decode(codeSource.getLocation().getPath());
            none$ = new Some((Object)new File(parsed).getPath());
        } else {
            none$ = None$.MODULE$;
        }
        None$ path = none$;
        return var3_4;
    }

    private UDFClassPath$() {
        MODULE$ = this;
        this.snowparkClass = Session.class;
        this.snowparkJar = new UDFClassPath.RequiredLibrary(this.getPathForClass(this.snowparkClass()), "snowpark", this.snowparkClass());
        this.jacksonDatabindClass = JsonNode.class;
        this.jacksonCoreClass = TreeNode.class;
        this.jacksonAnnotationClass = JsonView.class;
        this.jacksonJarSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UDFClassPath.RequiredLibrary[]{new UDFClassPath.RequiredLibrary(this.getPathForClass(this.jacksonDatabindClass()), "jackson-databind", this.jacksonDatabindClass()), new UDFClassPath.RequiredLibrary(this.getPathForClass(this.jacksonCoreClass()), "jackson-core", this.jacksonCoreClass()), new UDFClassPath.RequiredLibrary(this.getPathForClass(this.jacksonAnnotationClass()), "jackson-annotation", this.jacksonAnnotationClass())}));
        this.classpath = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(Product.class, (Object)"Scala ")}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Class c = (Class)tuple2._1();
            String description = (String)tuple2._2();
            UDFClassPath.RequiredLibrary requiredLibrary = new UDFClassPath.RequiredLibrary(MODULE$.getPathForClass(c), description, c);
            return requiredLibrary;
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UDFClassPath.RequiredLibrary[]{this.snowparkJar()})), Seq$.MODULE$.canBuildFrom());
    }
}

