/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.internal.analyzer.Alias;
import com.snowflake.snowpark.internal.analyzer.And;
import com.snowflake.snowpark.internal.analyzer.Expression;
import com.snowflake.snowpark.internal.analyzer.Filter;
import com.snowflake.snowpark.internal.analyzer.LogicalPlan;
import com.snowflake.snowpark.internal.analyzer.NamedExpression;
import com.snowflake.snowpark.internal.analyzer.Project;
import com.snowflake.snowpark.internal.analyzer.ProjectAndFilter;
import com.snowflake.snowpark.internal.analyzer.SimplificationPolicy;
import com.snowflake.snowpark.internal.analyzer.UnresolvedAlias;
import com.snowflake.snowpark.internal.analyzer.UnresolvedAttribute;
import com.snowflake.snowpark.internal.analyzer.package$;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class ProjectPlusFilterPolicy$
implements SimplificationPolicy {
    public static ProjectPlusFilterPolicy$ MODULE$;
    private final PartialFunction<LogicalPlan, LogicalPlan> rule;

    static {
        new ProjectPlusFilterPolicy$();
    }

    @Override
    public PartialFunction<LogicalPlan, LogicalPlan> rule() {
        return this.rule;
    }

    public boolean canMerge(Seq<NamedExpression> projectList, Expression condition) {
        boolean bl;
        boolean canAnalyzeProject = projectList.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProjectPlusFilterPolicy$.$anonfun$canMerge$1(x0$1)));
        boolean canAnalyzeCondition = condition.dependentColumnNames().isDefined();
        if (canAnalyzeCondition && canAnalyzeProject) {
            Set newProjectColumns = ((TraversableOnce)projectList.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Iterable iterable;
                NamedExpression namedExpression = x0$2;
                if (namedExpression instanceof Alias) {
                    Alias alias = (Alias)namedExpression;
                    String name = alias.name();
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)package$.MODULE$.quoteName(name)));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom())).toSet();
            Set conditionDependencies = (Set)condition.dependentColumnNames().get();
            bl = ((SetLike)newProjectColumns.$amp((GenSet)conditionDependencies)).isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$canMerge$1(NamedExpression x0$1) {
        NamedExpression namedExpression = x0$1;
        boolean bl = namedExpression instanceof UnresolvedAttribute ? false : !(namedExpression instanceof UnresolvedAlias);
        return bl;
    }

    private ProjectPlusFilterPolicy$() {
        MODULE$ = this;
        this.rule = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                Filter filter = null;
                A1 A1 = x1;
                if (A1 instanceof Filter) {
                    bl = true;
                    filter = (Filter)A1;
                    Expression condition = filter.condition();
                    LogicalPlan logicalPlan = filter.child();
                    if (logicalPlan instanceof Project) {
                        Project project = (Project)logicalPlan;
                        Seq<NamedExpression> projectList = project.projectList();
                        LogicalPlan child = project.child();
                        if (ProjectPlusFilterPolicy$.MODULE$.canMerge(projectList, condition)) {
                            object = new ProjectAndFilter(projectList, condition, child);
                            return (B1)object;
                        }
                    }
                }
                if (bl) {
                    Expression condition2 = filter.condition();
                    LogicalPlan logicalPlan = filter.child();
                    if (logicalPlan instanceof ProjectAndFilter) {
                        ProjectAndFilter projectAndFilter = (ProjectAndFilter)logicalPlan;
                        Seq<NamedExpression> projectList = projectAndFilter.projectList();
                        Expression condition1 = projectAndFilter.condition();
                        LogicalPlan child = projectAndFilter.child();
                        if (ProjectPlusFilterPolicy$.MODULE$.canMerge(projectList, condition2)) {
                            object = new ProjectAndFilter(projectList, new And(condition1, condition2), child);
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                boolean bl = false;
                Filter filter = null;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof Filter) {
                    Project project;
                    Seq<NamedExpression> projectList;
                    bl = true;
                    filter = (Filter)logicalPlan;
                    Expression condition = filter.condition();
                    LogicalPlan logicalPlan2 = filter.child();
                    if (logicalPlan2 instanceof Project && ProjectPlusFilterPolicy$.MODULE$.canMerge(projectList = (project = (Project)logicalPlan2).projectList(), condition)) {
                        return true;
                    }
                }
                if (!bl) return false;
                Expression condition2 = filter.condition();
                LogicalPlan logicalPlan3 = filter.child();
                if (!(logicalPlan3 instanceof ProjectAndFilter)) return false;
                ProjectAndFilter projectAndFilter = (ProjectAndFilter)logicalPlan3;
                Seq<NamedExpression> projectList = projectAndFilter.projectList();
                if (!ProjectPlusFilterPolicy$.MODULE$.canMerge(projectList, condition2)) return false;
                return true;
            }
        };
    }
}

