/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.refererparser;

import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import com.snowplowanalytics.refererparser.EmailMedium$;
import com.snowplowanalytics.refererparser.EmailReferer;
import com.snowplowanalytics.refererparser.InternalMedium$;
import com.snowplowanalytics.refererparser.InternalReferer;
import com.snowplowanalytics.refererparser.Medium;
import com.snowplowanalytics.refererparser.PaidMedium$;
import com.snowplowanalytics.refererparser.PaidReferer;
import com.snowplowanalytics.refererparser.Referer;
import com.snowplowanalytics.refererparser.RefererLookup;
import com.snowplowanalytics.refererparser.SearchMedium$;
import com.snowplowanalytics.refererparser.SearchReferer;
import com.snowplowanalytics.refererparser.SocialMedium$;
import com.snowplowanalytics.refererparser.SocialReferer;
import com.snowplowanalytics.refererparser.UnknownMedium$;
import com.snowplowanalytics.refererparser.UnknownReferer;
import java.io.Serializable;
import java.net.URI;
import java.net.URLDecoder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.compat.immutable.LazyList;
import scala.collection.compat.immutable.LazyList$;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\t\u0013\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0007g\u0001!\tA\u0005\u001b\t\u000b]\u0002A\u0011\u0002\u001d\t\u000b\u0019\u0003A\u0011A$\t\u000b\u0019\u0003A\u0011\u0001(\t\u000b\u0019\u0003A\u0011\u0001)\t\u000b\u0019\u0003A\u0011\u0001+\t\u000b\u0019\u0003A\u0011A,\t\u000b\u0019\u0003A\u0011A.\t\u000b\u0019\u0003A\u0011\u00010\t\u000b5\u0004A\u0011\u00028\t\u000bM\u0004A\u0011\u0002;\t\u000bi\u0004A\u0011B>\t\u000by\u0004A\u0011B@\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011\u0011\u0003\u0001\u0005\n\u0005M!A\u0002)beN,'O\u0003\u0002\u0014)\u0005i!/\u001a4fe\u0016\u0014\b/\u0019:tKJT!!\u0006\f\u0002#Mtwn\u001e9m_^\fg.\u00197zi&\u001c7OC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VMZ\u0001\te\u00164WM]3sgB!!%\u000b\u00170\u001d\t\u0019s\u0005\u0005\u0002%95\tQE\u0003\u0002'1\u00051AH]8pizJ!\u0001\u000b\u000f\u0002\rA\u0013X\rZ3g\u0013\tQ3FA\u0002NCBT!\u0001\u000b\u000f\u0011\u0005\tj\u0013B\u0001\u0018,\u0005\u0019\u0019FO]5oOB\u0011\u0001'M\u0007\u0002%%\u0011!G\u0005\u0002\u000e%\u00164WM]3s\u0019>|7.\u001e9\u0002\rqJg.\u001b;?)\t)d\u0007\u0005\u00021\u0001!)\u0001E\u0001a\u0001C\u0005)Ao\\+sSR\u0011\u0011\b\u0012\t\u00047ib\u0014BA\u001e\u001d\u0005\u0019y\u0005\u000f^5p]B\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0004]\u0016$(\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u00121!\u0016*J\u0011\u0015)5\u00011\u0001-\u0003\r)(/[\u0001\u0006a\u0006\u00148/\u001a\u000b\u0003\u00112\u00032a\u0007\u001eJ!\t\u0001$*\u0003\u0002L%\t9!+\u001a4fe\u0016\u0014\b\"B'\u0005\u0001\u0004a\u0014A\u0003:fM\u0016\u0014XM]+sSR\u0011\u0001j\u0014\u0005\u0006\u001b\u0016\u0001\r\u0001\f\u000b\u0004\u0011F\u0013\u0006\"B'\u0007\u0001\u0004a\u0004\"B*\u0007\u0001\u0004a\u0013\u0001\u00039bO\u0016Dun\u001d;\u0015\u0007!+f\u000bC\u0003N\u000f\u0001\u0007A\u0006C\u0003T\u000f\u0001\u0007A\u0006F\u0002I1fCQ!\u0014\u0005A\u0002qBQA\u0017\u0005A\u0002q\nq\u0001]1hKV\u0013\u0018\u000eF\u0002I9vCQ!T\u0005A\u00021BQAW\u0005A\u0002q\"B\u0001S0aE\")QJ\u0003a\u0001y!)1K\u0003a\u0001CB\u00191D\u000f\u0017\t\u000b\rT\u0001\u0019\u00013\u0002\u001f%tG/\u001a:oC2$u.\\1j]N\u00042!\u001a6-\u001d\t1\u0007N\u0004\u0002%O&\tQ$\u0003\u0002j9\u00059\u0001/Y2lC\u001e,\u0017BA6m\u0005\u0011a\u0015n\u001d;\u000b\u0005%d\u0012!E3yiJ\f7\r^*fCJ\u001c\u0007\u000eV3s[R\u0019\u0011m\\9\t\u000bA\\\u0001\u0019\u0001\u0017\u0002\u000bE,XM]=\t\u000bI\\\u0001\u0019\u00013\u0002%A|7o]5cY\u0016\u0004\u0016M]1nKR,'o]\u0001\u0013Kb$(/Y2u#V,'/\u001f)be\u0006l7\u000f\u0006\u0002vsB\u0019QM\u001b<\u0011\tm9H\u0006L\u0005\u0003qr\u0011a\u0001V;qY\u0016\u0014\u0004\"\u00029\r\u0001\u0004a\u0013!\u00043fG>$W-\u0016:j!\u0006\u0014H\u000f\u0006\u0002-y\")Q0\u0004a\u0001Y\u0005!\u0001/\u0019:u\u00035awn\\6vaJ+g-\u001a:feR1\u0011\u0011AA\u0002\u0003\u000f\u00012a\u0007\u001e0\u0011\u0019\t)A\u0004a\u0001Y\u0005Y!/\u001a4fe\u0016\u0014\bj\\:u\u0011\u0019\tIA\u0004a\u0001Y\u0005Y!/\u001a4fe\u0016\u0014\b+\u0019;i\u0003)Awn\u001d;t)>$&/\u001f\u000b\u0004I\u0006=\u0001BBA\u0003\u001f\u0001\u0007A&\u0001\u0006qCRD7\u000fV8Uef$2\u0001ZA\u000b\u0011\u0019\tI\u0001\u0005a\u0001Y\u0001")
public class Parser {
    private final Map<String, RefererLookup> referers;

    private Option<URI> toUri(String uri) {
        String string = uri;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : EitherObjectOps$.MODULE$.catchNonFatal$extension(package.either$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()), (Function0 & Serializable & scala.Serializable)() -> new URI(uri)).toOption();
    }

    public Option<Referer> parse(URI refererUri) {
        return this.parse(refererUri, (Option<String>)None$.MODULE$, (List<String>)Nil$.MODULE$);
    }

    public Option<Referer> parse(String refererUri) {
        return this.toUri(refererUri).flatMap((Function1 & Serializable & scala.Serializable)uri -> this.parse((URI)uri, (Option<String>)None$.MODULE$, (List<String>)Nil$.MODULE$));
    }

    public Option<Referer> parse(URI refererUri, String pageHost) {
        return this.parse(refererUri, (Option<String>)new Some((Object)pageHost), (List<String>)Nil$.MODULE$);
    }

    public Option<Referer> parse(String refererUri, String pageHost) {
        return this.toUri(refererUri).flatMap((Function1 & Serializable & scala.Serializable)uri -> this.parse((URI)uri, (Option<String>)new Some((Object)pageHost), (List<String>)Nil$.MODULE$));
    }

    public Option<Referer> parse(URI refererUri, URI pageUri) {
        return this.parse(refererUri, (Option<String>)new Some((Object)pageUri.getHost()), (List<String>)Nil$.MODULE$);
    }

    public Option<Referer> parse(String refererUri, URI pageUri) {
        return this.toUri(refererUri).flatMap((Function1 & Serializable & scala.Serializable)uri -> this.parse((URI)uri, (Option<String>)new Some((Object)pageUri.getHost()), (List<String>)Nil$.MODULE$));
    }

    public Option<Referer> parse(URI refererUri, Option<String> pageHost, List<String> internalDomains) {
        boolean validUri;
        String scheme = refererUri.getScheme();
        String host = refererUri.getHost();
        String path = refererUri.getPath();
        Option query = Option$.MODULE$.apply((Object)refererUri.getRawQuery());
        Seq validSchemes = (Seq)new .colon.colon((Object)"http", (List)new .colon.colon((Object)"https", (List)new .colon.colon((Object)"android-app", (List)Nil$.MODULE$)));
        boolean bl = validUri = validSchemes.contains((Object)scheme) && host != null && path != null;
        return validUri ? (pageHost.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals(host))) || ((LinearSeqOptimized)internalDomains.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), List$.MODULE$.canBuildFrom())).contains((Object)host) ? new Some((Object)new InternalReferer(InternalMedium$.MODULE$)) : new Some(this.lookupReferer(host, path).map((Function1 & Serializable & scala.Serializable)lookup -> {
            Product product;
            Medium medium = lookup.medium();
            if (UnknownMedium$.MODULE$.equals(medium)) {
                product = new UnknownReferer(UnknownMedium$.MODULE$);
            } else if (SearchMedium$.MODULE$.equals(medium)) {
                product = new SearchReferer(SearchMedium$.MODULE$, lookup.source(), (Option<String>)query.flatMap((Function1 & Serializable & scala.Serializable)q -> this.extractSearchTerm((String)q, lookup.parameters())));
            } else if (InternalMedium$.MODULE$.equals(medium)) {
                product = new InternalReferer(InternalMedium$.MODULE$);
            } else if (SocialMedium$.MODULE$.equals(medium)) {
                product = new SocialReferer(SocialMedium$.MODULE$, lookup.source());
            } else if (EmailMedium$.MODULE$.equals(medium)) {
                product = new EmailReferer(EmailMedium$.MODULE$, lookup.source());
            } else if (PaidMedium$.MODULE$.equals(medium)) {
                product = new PaidReferer(PaidMedium$.MODULE$, lookup.source());
            } else {
                throw new MatchError((Object)medium);
            }
            return product;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new UnknownReferer(UnknownMedium$.MODULE$)))) : None$.MODULE$;
    }

    private Option<String> extractSearchTerm(String query, List<String> possibleParameters) {
        return this.extractQueryParams(query).find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)possibleParameters.contains(p._1()))).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._2());
    }

    private List<Tuple2<String, String>> extractQueryParams(String query) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.split("&"))).toList().map((Function1 & Serializable & scala.Serializable)pair -> {
            int equalsIndex = pair.indexOf("=");
            return equalsIndex > 0 ? new Tuple2((Object)this.decodeUriPart(pair.substring(0, equalsIndex)), (Object)this.decodeUriPart(pair.substring(equalsIndex + 1))) : new Tuple2((Object)this.decodeUriPart((String)pair), (Object)"");
        }, List$.MODULE$.canBuildFrom());
    }

    private String decodeUriPart(String part) {
        return URLDecoder.decode(part, "UTF-8");
    }

    private Option<RefererLookup> lookupReferer(String refererHost, String refererPath) {
        List<String> hosts = this.hostsToTry(refererHost);
        List<String> paths = this.pathsToTry(refererPath);
        LazyList results = (LazyList)((LazyList)paths.to(scala.collection.compat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)LazyList$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)path -> (LazyList)((LazyList)hosts.to(scala.collection.compat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)LazyList$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)host -> (LazyList)((LazyList)Option$.MODULE$.option2Iterable($this.referers.get((Object)new StringBuilder(0).append((String)host).append((String)path).toString())).to(scala.collection.compat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)LazyList$.MODULE$))).map((Function1 & Serializable & scala.Serializable)result -> result, LazyList$.MODULE$.canBuildFrom()), LazyList$.MODULE$.canBuildFrom()), LazyList$.MODULE$.canBuildFrom());
        return results.headOption();
    }

    private List<String> hostsToTry(String refererHost) {
        return (List)((List)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])refererHost.split("\\."))).toList().scanRight((Object)"", (Function2 & Serializable & scala.Serializable)(part, full) -> new StringBuilder(1).append((String)part).append(".").append((String)full).toString(), List$.MODULE$.canBuildFrom())).init()).map((Function1 & Serializable & scala.Serializable)s -> s.substring(0, s.length() - 1), List$.MODULE$.canBuildFrom());
    }

    private List<String> pathsToTry(String refererPath) {
        .colon.colon colon2;
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])refererPath.split("/"))).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Parser.$anonfun$pathsToTry$1(x$4)));
        if (option instanceof Some) {
            Some some = (Some)option;
            String p = (String)some.value();
            colon2 = new .colon.colon((Object)refererPath, (List)new .colon.colon((Object)new StringBuilder(1).append("/").append(p).toString(), (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)));
        } else if (None$.MODULE$.equals(option)) {
            colon2 = new .colon.colon((Object)"", (List)Nil$.MODULE$);
        } else {
            throw new MatchError((Object)option);
        }
        return colon2;
    }

    public static final /* synthetic */ boolean $anonfun$pathsToTry$1(String x$4) {
        String string = x$4;
        String string2 = "";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public Parser(Map<String, RefererLookup> referers) {
        this.referers = referers;
    }
}

