/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.configuration.NetworkConfiguration;
import com.snowplowanalytics.snowplow.configuration.RemoteConfiguration;
import com.snowplowanalytics.snowplow.configuration.TrackerConfiguration;
import com.snowplowanalytics.snowplow.controller.TrackerController;
import com.snowplowanalytics.snowplow.internal.remoteconfiguration.ConfigurationBundle;
import com.snowplowanalytics.snowplow.internal.remoteconfiguration.ConfigurationProvider;
import com.snowplowanalytics.snowplow.internal.remoteconfiguration.FetchedConfigurationBundle;
import com.snowplowanalytics.snowplow.internal.tracker.ServiceProvider;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Snowplow {
    @Nullable
    private static ServiceProvider defaultServiceProvider;
    @NonNull
    private static final Map<String, ServiceProvider> serviceProviderInstances;
    @Nullable
    private static ConfigurationProvider configurationProvider;

    public static void setup(final @NonNull Context context, @NonNull RemoteConfiguration remoteConfiguration, @Nullable List<ConfigurationBundle> defaultBundles, final @Nullable Consumer<List<String>> onSuccess) {
        configurationProvider = new ConfigurationProvider(remoteConfiguration, defaultBundles);
        configurationProvider.retrieveConfiguration(context, false, new Consumer<FetchedConfigurationBundle>(){

            public void accept(FetchedConfigurationBundle fetchedConfigurationBundle) {
                List<ConfigurationBundle> bundles = fetchedConfigurationBundle.configurationBundle;
                List namespaces = Snowplow.createTracker(context, bundles);
                if (onSuccess != null) {
                    onSuccess.accept((Object)namespaces);
                }
            }
        });
    }

    public static void refresh(final @NonNull Context context, final @Nullable Consumer<List<String>> onSuccess) {
        if (configurationProvider == null) {
            return;
        }
        configurationProvider.retrieveConfiguration(context, true, new Consumer<FetchedConfigurationBundle>(){

            public void accept(FetchedConfigurationBundle fetchedConfigurationBundle) {
                List<ConfigurationBundle> bundles = fetchedConfigurationBundle.configurationBundle;
                List namespaces = Snowplow.createTracker(context, bundles);
                if (onSuccess != null) {
                    onSuccess.accept((Object)namespaces);
                }
            }
        });
    }

    @NonNull
    public static TrackerController createTracker(@NonNull Context context, @NonNull String namespace, @NonNull String endpoint, @NonNull HttpMethod method) {
        NetworkConfiguration network = new NetworkConfiguration(endpoint, method);
        TrackerConfiguration tracker = new TrackerConfiguration(context.getPackageName());
        return Snowplow.createTracker(context, namespace, network, tracker);
    }

    @NonNull
    public static TrackerController createTracker(@NonNull Context context, @NonNull String namespace, @NonNull NetworkConfiguration network, Configuration ... configurations) {
        ServiceProvider serviceProvider = serviceProviderInstances.get(namespace);
        if (serviceProvider != null) {
            ArrayList<Configuration> configList = new ArrayList<Configuration>(Arrays.asList(configurations));
            configList.add(network);
            serviceProvider.reset(configList);
        } else {
            serviceProvider = new ServiceProvider(context, namespace, network, Arrays.asList(configurations));
            Snowplow.registerInstance(serviceProvider);
        }
        return serviceProvider.getTrackerController();
    }

    @Nullable
    public static TrackerController getDefaultTracker() {
        ServiceProvider serviceProvider = defaultServiceProvider;
        return serviceProvider == null ? null : serviceProvider.getTrackerController();
    }

    @Nullable
    public static synchronized TrackerController getTracker(@NonNull String namespace) {
        ServiceProvider serviceProvider = serviceProviderInstances.get(namespace);
        if (serviceProvider == null) {
            return null;
        }
        return serviceProvider.getTrackerController();
    }

    public static synchronized boolean setTrackerAsDefault(@NonNull TrackerController trackerController) {
        ServiceProvider serviceProvider = serviceProviderInstances.get(trackerController.getNamespace());
        if (serviceProvider != null) {
            defaultServiceProvider = serviceProvider;
            return true;
        }
        return false;
    }

    public static synchronized boolean removeTracker(@NonNull TrackerController trackerController) {
        String namespace = trackerController.getNamespace();
        ServiceProvider serviceProvider = serviceProviderInstances.get(namespace);
        if (serviceProvider != null) {
            serviceProvider.shutdown();
            serviceProviderInstances.remove(namespace);
            if (serviceProvider == defaultServiceProvider) {
                defaultServiceProvider = null;
            }
            return true;
        }
        return false;
    }

    public static synchronized void removeAllTrackers() {
        defaultServiceProvider = null;
        Collection<ServiceProvider> serviceProviders = serviceProviderInstances.values();
        serviceProviderInstances.clear();
        for (ServiceProvider sp : serviceProviders) {
            sp.shutdown();
        }
    }

    @NonNull
    public static Set<String> getInstancedTrackerNamespaces() {
        return serviceProviderInstances.keySet();
    }

    @NonNull
    private static synchronized List<String> createTracker(@NonNull Context context, @NonNull List<ConfigurationBundle> bundles) {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (ConfigurationBundle bundle : bundles) {
            if (bundle.networkConfiguration == null) {
                TrackerController tracker = Snowplow.getTracker(bundle.namespace);
                if (tracker == null) continue;
                Snowplow.removeTracker(tracker);
                continue;
            }
            List<Configuration> list = bundle.getConfigurations();
            Configuration[] array = list.toArray(new Configuration[list.size()]);
            Snowplow.createTracker(context, bundle.namespace, bundle.networkConfiguration, array);
            namespaces.add(bundle.namespace);
        }
        return namespaces;
    }

    private static synchronized boolean registerInstance(@NonNull ServiceProvider serviceProvider) {
        boolean isOverriding;
        String namespace = serviceProvider.getNamespace();
        boolean bl = isOverriding = serviceProviderInstances.put(namespace, serviceProvider) != null;
        if (defaultServiceProvider == null) {
            defaultServiceProvider = serviceProvider;
        }
        return isOverriding;
    }

    static {
        serviceProviderInstances = new HashMap<String, ServiceProvider>();
    }
}

