/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.configuration;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.internal.emitter.NetworkConfigurationInterface;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import com.snowplowanalytics.snowplow.network.NetworkConnection;
import com.snowplowanalytics.snowplow.network.Protocol;
import java.util.Objects;
import okhttp3.OkHttpClient;
import org.json.JSONObject;

public class NetworkConfiguration
implements NetworkConfigurationInterface,
Configuration {
    private static final String TAG = NetworkConfiguration.class.getSimpleName();
    @Nullable
    private String endpoint;
    @Nullable
    private HttpMethod method;
    @Nullable
    private Protocol protocol;
    @Nullable
    public NetworkConnection networkConnection;
    @Nullable
    public String customPostPath;
    @Nullable
    public Integer timeout;
    @Nullable
    public OkHttpClient okHttpClient;

    public NetworkConfiguration(@NonNull String endpoint) {
        this(endpoint, HttpMethod.POST);
    }

    public NetworkConfiguration(@NonNull String endpoint, @NonNull HttpMethod method) {
        Objects.requireNonNull(method);
        this.method = method;
        Objects.requireNonNull(endpoint);
        Uri uri = Uri.parse((String)endpoint);
        String scheme = uri.getScheme();
        if (scheme == null) {
            this.protocol = Protocol.HTTPS;
            this.endpoint = "https://" + endpoint;
            return;
        }
        switch (scheme) {
            case "https": {
                this.protocol = Protocol.HTTPS;
                this.endpoint = endpoint;
                break;
            }
            case "http": {
                this.protocol = Protocol.HTTP;
                this.endpoint = endpoint;
                break;
            }
            default: {
                this.protocol = Protocol.HTTPS;
                this.endpoint = "https://" + endpoint;
            }
        }
    }

    public NetworkConfiguration(@NonNull NetworkConnection networkConnection) {
        Objects.requireNonNull(networkConnection);
        this.networkConnection = networkConnection;
    }

    @Override
    @Nullable
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    @Nullable
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    @Nullable
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    @Nullable
    public String getCustomPostPath() {
        return this.customPostPath;
    }

    @Override
    @Nullable
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    @Nullable
    public NetworkConnection getNetworkConnection() {
        return this.networkConnection;
    }

    @Override
    @Nullable
    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    @NonNull
    public NetworkConfiguration customPostPath(@NonNull String customPostPath) {
        this.customPostPath = customPostPath;
        return this;
    }

    @NonNull
    public NetworkConfiguration timeout(@NonNull Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @NonNull
    public NetworkConfiguration okHttpClient(@NonNull OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        return this;
    }

    @Override
    @NonNull
    public Configuration copy() {
        NetworkConfiguration copy;
        if (this.networkConnection != null) {
            copy = new NetworkConfiguration(this.networkConnection);
        } else {
            Objects.requireNonNull(this.endpoint);
            Objects.requireNonNull(this.protocol);
            Objects.requireNonNull(this.method);
            String scheme = this.protocol == Protocol.HTTPS ? "https://" : "http://";
            copy = new NetworkConfiguration(scheme + this.endpoint, this.method);
        }
        copy.customPostPath = this.customPostPath;
        copy.timeout = this.timeout;
        return copy;
    }

    public NetworkConfiguration(@NonNull JSONObject jsonObject) {
        this("");
        try {
            this.endpoint = jsonObject.getString("endpoint");
            String methodStr = jsonObject.getString("method");
            this.method = HttpMethod.valueOf(methodStr.toUpperCase());
        }
        catch (Exception e) {
            Logger.e(TAG, "Unable to get remote configuration", new Object[0]);
        }
    }
}

