/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.configuration;

import android.net.Uri;
import androidx.annotation.NonNull;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import java.util.Arrays;
import java.util.Objects;

public class RemoteConfiguration
implements Configuration {
    @NonNull
    public final String endpoint;
    @NonNull
    public final HttpMethod method;

    public RemoteConfiguration(@NonNull String endpoint, @NonNull HttpMethod method) {
        Objects.requireNonNull(method);
        this.method = method;
        Objects.requireNonNull(endpoint);
        Uri uri = Uri.parse((String)endpoint);
        String scheme = uri.getScheme();
        this.endpoint = scheme != null && Arrays.asList("https", "http").contains(scheme) ? endpoint : "https://" + endpoint;
    }

    @Override
    @NonNull
    public Configuration copy() {
        return new RemoteConfiguration(this.endpoint, this.method);
    }
}

