/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.configuration;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.internal.session.SessionConfigurationInterface;
import com.snowplowanalytics.snowplow.tracker.SessionState;
import com.snowplowanalytics.snowplow.util.TimeMeasure;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class SessionConfiguration
implements SessionConfigurationInterface,
Configuration {
    @NonNull
    public TimeMeasure foregroundTimeout;
    @NonNull
    public TimeMeasure backgroundTimeout;
    @Nullable
    public Consumer<SessionState> onSessionUpdate;

    public SessionConfiguration(@NonNull TimeMeasure foregroundTimeout, @NonNull TimeMeasure backgroundTimeout) {
        this.foregroundTimeout = foregroundTimeout;
        this.backgroundTimeout = backgroundTimeout;
    }

    @Override
    @NonNull
    public TimeMeasure getForegroundTimeout() {
        return this.foregroundTimeout;
    }

    @Override
    public void setForegroundTimeout(@NonNull TimeMeasure foregroundTimeout) {
        this.foregroundTimeout = foregroundTimeout;
    }

    @Override
    @NonNull
    public TimeMeasure getBackgroundTimeout() {
        return this.backgroundTimeout;
    }

    @Override
    public void setBackgroundTimeout(@NonNull TimeMeasure backgroundTimeout) {
        this.backgroundTimeout = backgroundTimeout;
    }

    @Override
    @Nullable
    public Consumer<SessionState> getOnSessionUpdate() {
        return this.onSessionUpdate;
    }

    @Override
    public void setOnSessionUpdate(@Nullable Consumer<SessionState> onSessionUpdate) {
        this.onSessionUpdate = onSessionUpdate;
    }

    @NonNull
    public SessionConfiguration onSessionUpdate(@Nullable Consumer<SessionState> onSessionUpdate) {
        this.onSessionUpdate = onSessionUpdate;
        return this;
    }

    @Override
    @NonNull
    public Configuration copy() {
        return new SessionConfiguration(this.foregroundTimeout, this.backgroundTimeout).onSessionUpdate(this.onSessionUpdate);
    }

    public SessionConfiguration(@NonNull JSONObject jsonObject) {
        this(new TimeMeasure(30L, TimeUnit.MINUTES), new TimeMeasure(30L, TimeUnit.MINUTES));
        int foregroundTimeout = jsonObject.optInt("foregroundTimeout", 1800);
        int backgroundTimeout = jsonObject.optInt("backgroundTimeout", 1800);
        this.foregroundTimeout = new TimeMeasure(foregroundTimeout, TimeUnit.SECONDS);
        this.backgroundTimeout = new TimeMeasure(backgroundTimeout, TimeUnit.SECONDS);
    }
}

