/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.configuration;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.tracker.TrackerConfigurationInterface;
import com.snowplowanalytics.snowplow.tracker.DevicePlatform;
import com.snowplowanalytics.snowplow.tracker.LogLevel;
import com.snowplowanalytics.snowplow.tracker.LoggerDelegate;
import org.json.JSONObject;

public class TrackerConfiguration
implements TrackerConfigurationInterface,
Configuration {
    public static final String TAG = TrackerConfiguration.class.getSimpleName();
    @NonNull
    public String appId;
    @NonNull
    public DevicePlatform devicePlatform;
    public boolean base64encoding;
    @NonNull
    public LogLevel logLevel;
    @Nullable
    public LoggerDelegate loggerDelegate;
    public boolean applicationContext;
    public boolean platformContext;
    public boolean geoLocationContext;
    public boolean sessionContext;
    public boolean deepLinkContext;
    public boolean screenContext;
    public boolean screenViewAutotracking;
    public boolean lifecycleAutotracking;
    public boolean installAutotracking;
    public boolean exceptionAutotracking;
    public boolean diagnosticAutotracking;
    @Nullable
    public String trackerVersionSuffix;

    @Override
    @NonNull
    public String getAppId() {
        return this.appId;
    }

    @Override
    public void setAppId(@NonNull String appId) {
        this.appId = appId;
    }

    @Override
    @NonNull
    public DevicePlatform getDevicePlatform() {
        return this.devicePlatform;
    }

    @Override
    public void setDevicePlatform(@NonNull DevicePlatform devicePlatform) {
        this.devicePlatform = devicePlatform;
    }

    @Override
    public boolean isBase64encoding() {
        return this.base64encoding;
    }

    @Override
    public void setBase64encoding(boolean base64encoding) {
        this.base64encoding = base64encoding;
    }

    @Override
    @NonNull
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(@NonNull LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    @Nullable
    public LoggerDelegate getLoggerDelegate() {
        return this.loggerDelegate;
    }

    @Override
    public void setLoggerDelegate(@Nullable LoggerDelegate loggerDelegate) {
        this.loggerDelegate = loggerDelegate;
    }

    @Override
    public boolean isApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void setApplicationContext(boolean applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public boolean isPlatformContext() {
        return this.platformContext;
    }

    @Override
    public void setPlatformContext(boolean platformContext) {
        this.platformContext = platformContext;
    }

    @Override
    public boolean isGeoLocationContext() {
        return this.geoLocationContext;
    }

    @Override
    public void setGeoLocationContext(boolean geoLocationContext) {
        this.geoLocationContext = geoLocationContext;
    }

    @Override
    public boolean isSessionContext() {
        return this.sessionContext;
    }

    @Override
    public void setSessionContext(boolean sessionContext) {
        this.sessionContext = sessionContext;
    }

    @Override
    public boolean isDeepLinkContext() {
        return this.deepLinkContext;
    }

    @Override
    public void setDeepLinkContext(boolean deepLinkContext) {
        this.deepLinkContext = deepLinkContext;
    }

    @Override
    public boolean isScreenContext() {
        return this.screenContext;
    }

    @Override
    public void setScreenContext(boolean screenContext) {
        this.screenContext = screenContext;
    }

    @Override
    public boolean isScreenViewAutotracking() {
        return this.screenViewAutotracking;
    }

    @Override
    public void setScreenViewAutotracking(boolean screenViewAutotracking) {
        this.screenViewAutotracking = screenViewAutotracking;
    }

    @Override
    public boolean isLifecycleAutotracking() {
        return this.lifecycleAutotracking;
    }

    @Override
    public void setLifecycleAutotracking(boolean lifecycleAutotracking) {
        this.lifecycleAutotracking = lifecycleAutotracking;
    }

    @Override
    public boolean isInstallAutotracking() {
        return this.installAutotracking;
    }

    @Override
    public void setInstallAutotracking(boolean installAutotracking) {
        this.installAutotracking = installAutotracking;
    }

    @Override
    public boolean isExceptionAutotracking() {
        return this.exceptionAutotracking;
    }

    @Override
    public void setExceptionAutotracking(boolean exceptionAutotracking) {
        this.exceptionAutotracking = exceptionAutotracking;
    }

    @Override
    public boolean isDiagnosticAutotracking() {
        return this.diagnosticAutotracking;
    }

    @Override
    public void setDiagnosticAutotracking(boolean diagnosticAutotracking) {
        this.diagnosticAutotracking = diagnosticAutotracking;
    }

    @Override
    @Nullable
    public String getTrackerVersionSuffix() {
        return this.trackerVersionSuffix;
    }

    @Override
    public void setTrackerVersionSuffix(@Nullable String trackerVersionSuffix) {
        this.trackerVersionSuffix = trackerVersionSuffix;
    }

    public TrackerConfiguration(@NonNull String appId) {
        this.appId = appId;
        this.devicePlatform = DevicePlatform.Mobile;
        this.base64encoding = true;
        this.logLevel = LogLevel.OFF;
        this.loggerDelegate = null;
        this.sessionContext = true;
        this.applicationContext = true;
        this.platformContext = true;
        this.geoLocationContext = false;
        this.deepLinkContext = true;
        this.screenContext = true;
        this.screenViewAutotracking = true;
        this.lifecycleAutotracking = false;
        this.installAutotracking = true;
        this.exceptionAutotracking = true;
        this.diagnosticAutotracking = false;
    }

    @NonNull
    public TrackerConfiguration appId(@NonNull String appId) {
        this.appId = appId;
        return this;
    }

    @NonNull
    public TrackerConfiguration devicePlatform(@NonNull DevicePlatform devicePlatform) {
        this.devicePlatform = devicePlatform;
        return this;
    }

    @NonNull
    public TrackerConfiguration base64encoding(boolean base64encoding) {
        this.base64encoding = base64encoding;
        return this;
    }

    @NonNull
    public TrackerConfiguration logLevel(@NonNull LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @NonNull
    public TrackerConfiguration loggerDelegate(@Nullable LoggerDelegate loggerDelegate) {
        this.loggerDelegate = loggerDelegate;
        return this;
    }

    @NonNull
    public TrackerConfiguration applicationContext(boolean applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    @NonNull
    public TrackerConfiguration platformContext(boolean platformContext) {
        this.platformContext = platformContext;
        return this;
    }

    @NonNull
    public TrackerConfiguration geoLocationContext(boolean geoLocationContext) {
        this.geoLocationContext = geoLocationContext;
        return this;
    }

    @NonNull
    public TrackerConfiguration sessionContext(boolean sessionContext) {
        this.sessionContext = sessionContext;
        return this;
    }

    @NonNull
    public TrackerConfiguration deepLinkContext(boolean deepLinkContext) {
        this.deepLinkContext = deepLinkContext;
        return this;
    }

    @NonNull
    public TrackerConfiguration screenContext(boolean screenContext) {
        this.screenContext = screenContext;
        return this;
    }

    @NonNull
    public TrackerConfiguration screenViewAutotracking(boolean screenViewAutotracking) {
        this.screenViewAutotracking = screenViewAutotracking;
        return this;
    }

    @NonNull
    public TrackerConfiguration lifecycleAutotracking(boolean lifecycleAutotracking) {
        this.lifecycleAutotracking = lifecycleAutotracking;
        return this;
    }

    @NonNull
    public TrackerConfiguration installAutotracking(boolean installAutotracking) {
        this.installAutotracking = installAutotracking;
        return this;
    }

    @NonNull
    public TrackerConfiguration exceptionAutotracking(boolean exceptionAutotracking) {
        this.exceptionAutotracking = exceptionAutotracking;
        return this;
    }

    @NonNull
    public TrackerConfiguration diagnosticAutotracking(boolean diagnosticAutotracking) {
        this.diagnosticAutotracking = diagnosticAutotracking;
        return this;
    }

    @NonNull
    public TrackerConfiguration trackerVersionSuffix(@Nullable String trackerVersionSuffix) {
        this.trackerVersionSuffix = trackerVersionSuffix;
        return this;
    }

    @Override
    @NonNull
    public Configuration copy() {
        TrackerConfiguration copy = new TrackerConfiguration(this.appId);
        copy.devicePlatform = this.devicePlatform;
        copy.base64encoding = this.base64encoding;
        copy.logLevel = this.logLevel;
        copy.loggerDelegate = this.loggerDelegate;
        copy.sessionContext = this.sessionContext;
        copy.applicationContext = this.applicationContext;
        copy.platformContext = this.platformContext;
        copy.geoLocationContext = this.geoLocationContext;
        copy.screenContext = this.screenContext;
        copy.deepLinkContext = this.deepLinkContext;
        copy.screenViewAutotracking = this.screenViewAutotracking;
        copy.lifecycleAutotracking = this.lifecycleAutotracking;
        copy.installAutotracking = this.installAutotracking;
        copy.exceptionAutotracking = this.exceptionAutotracking;
        copy.diagnosticAutotracking = this.diagnosticAutotracking;
        copy.trackerVersionSuffix = this.trackerVersionSuffix;
        return copy;
    }

    public TrackerConfiguration(@NonNull String appId, @NonNull JSONObject jsonObject) {
        this(jsonObject.optString("appId", appId));
        String val = jsonObject.optString("devicePlatform", DevicePlatform.Mobile.getValue());
        this.devicePlatform = DevicePlatform.getByValue(val);
        this.base64encoding = jsonObject.optBoolean("base64encoding", this.base64encoding);
        String log = jsonObject.optString("logLevel", LogLevel.OFF.name());
        try {
            this.logLevel = LogLevel.valueOf(log.toUpperCase());
        }
        catch (Exception e) {
            Logger.e(TAG, "Unable to decode `logLevel from remote configuration.", new Object[0]);
        }
        this.sessionContext = jsonObject.optBoolean("sessionContext", this.sessionContext);
        this.applicationContext = jsonObject.optBoolean("applicationContext", this.applicationContext);
        this.platformContext = jsonObject.optBoolean("platformContext", this.platformContext);
        this.geoLocationContext = jsonObject.optBoolean("geoLocationContext", this.geoLocationContext);
        this.screenContext = jsonObject.optBoolean("screenContext", this.screenContext);
        this.deepLinkContext = jsonObject.optBoolean("deepLinkContext", this.deepLinkContext);
        this.screenViewAutotracking = jsonObject.optBoolean("screenViewAutotracking", this.screenViewAutotracking);
        this.lifecycleAutotracking = jsonObject.optBoolean("lifecycleAutotracking", this.lifecycleAutotracking);
        this.installAutotracking = jsonObject.optBoolean("installAutotracking", this.installAutotracking);
        this.exceptionAutotracking = jsonObject.optBoolean("exceptionAutotracking", this.exceptionAutotracking);
        this.diagnosticAutotracking = jsonObject.optBoolean("diagnosticAutotracking", this.diagnosticAutotracking);
    }
}

