/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.internal.utils.Preconditions;
import com.snowplowanalytics.snowplow.payload.TrackerPayload;
import java.util.Map;

public class ConsentDocument
extends AbstractSelfDescribing {
    @NonNull
    public final String documentId;
    @NonNull
    public final String documentVersion;
    @Nullable
    public String documentName;
    @Nullable
    public String documentDescription;

    public ConsentDocument(@NonNull String documentId, @NonNull String documentVersion) {
        Preconditions.checkNotNull(documentId);
        Preconditions.checkArgument(!documentId.isEmpty(), "Document ID cannot be empty");
        Preconditions.checkNotNull(documentVersion);
        Preconditions.checkArgument(!documentVersion.isEmpty(), "Document version cannot be empty");
        this.documentId = documentId;
        this.documentVersion = documentVersion;
    }

    @NonNull
    public ConsentDocument documentName(@Nullable String documentName) {
        this.documentName = documentName;
        return this;
    }

    @NonNull
    public ConsentDocument documentDescription(@Nullable String documentDescription) {
        this.documentDescription = documentDescription;
        return this;
    }

    @Override
    @NonNull
    public Map<String, Object> getDataPayload() {
        TrackerPayload payload = new TrackerPayload();
        payload.add("id", this.documentId);
        payload.add("name", this.documentName);
        payload.add("description", this.documentDescription);
        payload.add("version", this.documentVersion);
        return payload.getMap();
    }

    @Override
    @NonNull
    public String getSchema() {
        return "iglu:com.snowplowanalytics.snowplow/consent_document/jsonschema/1-0-0";
    }
}

