/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.event.ConsentDocument;
import com.snowplowanalytics.snowplow.internal.tracker.Tracker;
import com.snowplowanalytics.snowplow.internal.utils.Preconditions;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConsentWithdrawn
extends AbstractSelfDescribing {
    public final boolean all;
    @NonNull
    public final String documentId;
    @NonNull
    public final String documentVersion;
    @Nullable
    public String documentName;
    @Nullable
    public String documentDescription;
    @NonNull
    public final List<ConsentDocument> consentDocuments = new LinkedList<ConsentDocument>();

    public ConsentWithdrawn(boolean all, @NonNull String documentId, @NonNull String documentVersion) {
        Preconditions.checkNotNull(documentId);
        Preconditions.checkArgument(!documentId.isEmpty(), "Document ID cannot be empty");
        Preconditions.checkNotNull(documentVersion);
        Preconditions.checkArgument(!documentVersion.isEmpty(), "Document version cannot be empty");
        this.all = all;
        this.documentId = documentId;
        this.documentVersion = documentVersion;
    }

    @NonNull
    public ConsentWithdrawn documentName(@Nullable String documentName) {
        this.documentName = documentName;
        return this;
    }

    @NonNull
    public ConsentWithdrawn documentDescription(@Nullable String documentDescription) {
        this.documentDescription = documentDescription;
        return this;
    }

    @NonNull
    public ConsentWithdrawn documents(@NonNull List<ConsentDocument> documents) {
        this.consentDocuments.clear();
        this.consentDocuments.addAll(documents);
        return this;
    }

    @NonNull
    public List<ConsentDocument> getDocuments() {
        ArrayList<ConsentDocument> docs = new ArrayList<ConsentDocument>();
        ConsentDocument doc = new ConsentDocument(this.documentId, this.documentVersion).documentDescription(this.documentDescription).documentName(this.documentName);
        docs.add(doc);
        docs.addAll(this.consentDocuments);
        return docs;
    }

    @Override
    @NonNull
    public Map<String, Object> getDataPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("all", this.all);
        return payload;
    }

    @Override
    @NonNull
    public String getSchema() {
        return "iglu:com.snowplowanalytics.snowplow/consent_withdrawn/jsonschema/1-0-0";
    }

    @Override
    public void beginProcessing(@NonNull Tracker tracker) {
        for (ConsentDocument document : this.getDocuments()) {
            SelfDescribingJson context = new SelfDescribingJson(document.getSchema(), document.getDataPayload());
            this.customContexts.add(context);
        }
    }
}

