/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.installreferrer.api.ReferrerDetails;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import java.util.HashMap;
import java.util.Map;

public class DeepLinkReceived
extends AbstractSelfDescribing {
    public static final String SCHEMA = "iglu:com.snowplowanalytics.mobile/deep_link_received/jsonschema/1-0-0";
    public static final String PARAM_REFERRER = "referrer";
    public static final String PARAM_URL = "url";
    @Nullable
    public String referrer;
    @NonNull
    public final String url;

    public DeepLinkReceived(@NonNull String url) {
        this.url = url;
    }

    @Nullable
    public static DeepLinkReceived fromIntent(@Nullable Intent intent) {
        Uri referrerUri;
        if (intent == null) {
            return null;
        }
        Uri uri = intent.getData();
        if (uri == null) {
            return null;
        }
        String deepLinkUrl = uri.toString();
        String referrer = null;
        Bundle extras = intent.getExtras();
        if (extras != null && (referrerUri = (Uri)extras.get("android.intent.extra.REFERRER")) != null) {
            referrer = referrerUri.toString();
        }
        return new DeepLinkReceived(deepLinkUrl).referrer(referrer);
    }

    @Nullable
    public static DeepLinkReceived fromReferrerDetails(@Nullable ReferrerDetails referrerDetails) {
        if (referrerDetails == null) {
            return null;
        }
        String deepLinkUrl = referrerDetails.getInstallReferrer();
        if (deepLinkUrl == null) {
            return null;
        }
        return new DeepLinkReceived(deepLinkUrl);
    }

    @NonNull
    public DeepLinkReceived referrer(@Nullable String referrer) {
        this.referrer = referrer;
        return this;
    }

    @Override
    @NonNull
    public Map<String, Object> getDataPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(PARAM_URL, this.url);
        if (this.referrer != null) {
            payload.put(PARAM_REFERRER, this.referrer);
        }
        return payload;
    }

    @Override
    @NonNull
    public String getSchema() {
        return SCHEMA;
    }
}

