/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.AbstractPrimitive;
import com.snowplowanalytics.snowplow.event.EcommerceTransactionItem;
import com.snowplowanalytics.snowplow.internal.tracker.Tracker;
import com.snowplowanalytics.snowplow.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EcommerceTransaction
extends AbstractPrimitive {
    @NonNull
    public final String orderId;
    @NonNull
    public final Double totalValue;
    @NonNull
    public final List<EcommerceTransactionItem> items;
    @Nullable
    public String affiliation;
    @Nullable
    public Double taxValue;
    @Nullable
    public Double shipping;
    @Nullable
    public String city;
    @Nullable
    public String state;
    @Nullable
    public String country;
    @Nullable
    public String currency;

    public EcommerceTransaction(@NonNull String orderId, @NonNull Double totalValue, @NonNull List<EcommerceTransactionItem> items) {
        Preconditions.checkNotNull(orderId);
        Preconditions.checkArgument(!orderId.isEmpty(), "orderId cannot be empty");
        Preconditions.checkNotNull(totalValue);
        Preconditions.checkNotNull(items);
        this.orderId = orderId;
        this.totalValue = totalValue;
        this.items = new ArrayList<EcommerceTransactionItem>(items);
    }

    @NonNull
    public EcommerceTransaction affiliation(@Nullable String affiliation) {
        this.affiliation = affiliation;
        return this;
    }

    @NonNull
    public EcommerceTransaction taxValue(@Nullable Double taxValue) {
        this.taxValue = taxValue;
        return this;
    }

    @NonNull
    public EcommerceTransaction shipping(@Nullable Double shipping) {
        this.shipping = shipping;
        return this;
    }

    @NonNull
    public EcommerceTransaction city(@Nullable String city) {
        this.city = city;
        return this;
    }

    @NonNull
    public EcommerceTransaction state(@Nullable String state) {
        this.state = state;
        return this;
    }

    @NonNull
    public EcommerceTransaction country(@Nullable String country) {
        this.country = country;
        return this;
    }

    @NonNull
    public EcommerceTransaction currency(@Nullable String currency) {
        this.currency = currency;
        return this;
    }

    @Override
    @NonNull
    public Map<String, Object> getDataPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>(9);
        payload.put("tr_id", this.orderId);
        payload.put("tr_tt", Double.toString(this.totalValue));
        if (this.affiliation != null) {
            payload.put("tr_af", this.affiliation);
        }
        if (this.taxValue != null) {
            payload.put("tr_tx", Double.toString(this.taxValue));
        }
        if (this.shipping != null) {
            payload.put("tr_sh", Double.toString(this.shipping));
        }
        if (this.city != null) {
            payload.put("tr_ci", this.city);
        }
        if (this.state != null) {
            payload.put("tr_st", this.state);
        }
        if (this.country != null) {
            payload.put("tr_co", this.country);
        }
        if (this.currency != null) {
            payload.put("tr_cu", this.currency);
        }
        return payload;
    }

    @Override
    @NonNull
    public String getName() {
        return "tr";
    }

    @NonNull
    public List<EcommerceTransactionItem> getItems() {
        return this.items;
    }

    @Override
    public void endProcessing(@NonNull Tracker tracker) {
        for (EcommerceTransactionItem item : this.items) {
            item.orderId = this.orderId;
            tracker.track(item);
        }
    }
}

