/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.AbstractPrimitive;
import com.snowplowanalytics.snowplow.internal.utils.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class EcommerceTransactionItem
extends AbstractPrimitive {
    @NonNull
    public final String sku;
    @NonNull
    public final Double price;
    @NonNull
    public final Integer quantity;
    @Nullable
    public String name;
    @Nullable
    public String category;
    @Nullable
    public String currency;
    @Nullable
    public String orderId;

    public EcommerceTransactionItem(@NonNull String sku, double price, int quantity) {
        Preconditions.checkNotNull(sku);
        Preconditions.checkArgument(!sku.isEmpty(), "sku cannot be empty");
        this.sku = sku;
        this.price = price;
        this.quantity = quantity;
    }

    @NonNull
    public EcommerceTransactionItem name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @NonNull
    public EcommerceTransactionItem category(@Nullable String category) {
        this.category = category;
        return this;
    }

    @NonNull
    public EcommerceTransactionItem currency(@Nullable String currency) {
        this.currency = currency;
        return this;
    }

    @NonNull
    public EcommerceTransactionItem orderId(@Nullable String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Override
    @NonNull
    public Map<String, Object> getDataPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (this.orderId != null) {
            payload.put("ti_id", this.orderId);
        }
        payload.put("ti_sk", this.sku);
        payload.put("ti_pr", Double.toString(this.price));
        payload.put("ti_qu", Integer.toString(this.quantity));
        if (this.name != null) {
            payload.put("ti_nm", this.name);
        }
        if (this.category != null) {
            payload.put("ti_ca", this.category);
        }
        if (this.currency != null) {
            payload.put("ti_cu", this.currency);
        }
        return payload;
    }

    @Override
    @NonNull
    public String getName() {
        return "ti";
    }
}

