/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.AbstractPrimitive;
import com.snowplowanalytics.snowplow.internal.utils.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class PageView
extends AbstractPrimitive {
    @NonNull
    private final String pageUrl;
    @Nullable
    private String pageTitle;
    @Nullable
    private String referrer;

    public PageView(@NonNull String pageUrl) {
        Preconditions.checkNotNull(pageUrl);
        Preconditions.checkArgument(!pageUrl.isEmpty(), "pageUrl cannot be empty");
        this.pageUrl = pageUrl;
    }

    @NonNull
    public PageView pageTitle(@Nullable String pageTitle) {
        this.pageTitle = pageTitle;
        return this;
    }

    @NonNull
    public PageView referrer(@Nullable String referrer) {
        this.referrer = referrer;
        return this;
    }

    @Override
    @NonNull
    public Map<String, Object> getDataPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("url", this.pageUrl);
        if (this.pageTitle != null) {
            payload.put("page", this.pageTitle);
        }
        if (this.referrer != null) {
            payload.put("refr", this.referrer);
        }
        return payload;
    }

    @Override
    @NonNull
    public String getName() {
        return "pv";
    }
}

