/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import android.app.Activity;
import android.app.Fragment;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.utils.Preconditions;
import com.snowplowanalytics.snowplow.internal.utils.Util;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ScreenView
extends AbstractSelfDescribing {
    private static final String TAG = ScreenView.class.getSimpleName();
    @NonNull
    public final String name;
    @NonNull
    public final String id;
    @Nullable
    public String type;
    @Nullable
    public String previousName;
    @Nullable
    public String previousId;
    @Nullable
    public String previousType;
    @Nullable
    public String transitionType;
    @Nullable
    public String fragmentClassName;
    @Nullable
    public String fragmentTag;
    @Nullable
    public String activityClassName;
    @Nullable
    public String activityTag;

    @NonNull
    public static ScreenView buildWithActivity(@NonNull Activity activity) {
        String activityClassName = activity.getLocalClassName();
        String activityTag = ScreenView.getSnowplowScreenId(activity);
        String name = ScreenView.getValidName(activityClassName, activityTag);
        return new ScreenView(name).activityClassName(activityClassName).activityTag(activityTag).fragmentClassName(null).fragmentTag(null).type(activityClassName).transitionType(null);
    }

    @NonNull
    public static ScreenView buildWithFragment(@NonNull Fragment fragment) {
        String fragmentClassName = fragment.getClass().getSimpleName();
        String fragmentTag = fragment.getTag();
        String name = ScreenView.getValidName(fragmentClassName, fragmentTag);
        return new ScreenView(name).activityClassName(null).activityTag(null).fragmentClassName(fragment.getClass().getSimpleName()).fragmentTag(fragment.getTag()).type(fragmentClassName).transitionType(null);
    }

    public ScreenView(@NonNull String name) {
        this(name, null);
    }

    public ScreenView(@NonNull String name, @Nullable UUID screenId) {
        Preconditions.checkNotNull(name);
        Preconditions.checkArgument(!name.isEmpty(), "Name cannot be empty.");
        this.name = name;
        this.id = screenId != null ? screenId.toString() : Util.getUUIDString();
    }

    @NonNull
    public ScreenView type(@Nullable String type) {
        this.type = type;
        return this;
    }

    @NonNull
    public ScreenView previousName(@Nullable String previousName) {
        this.previousName = previousName;
        return this;
    }

    @NonNull
    public ScreenView previousId(@Nullable String previousId) {
        this.previousId = previousId;
        return this;
    }

    @NonNull
    public ScreenView previousType(@Nullable String previousType) {
        this.previousType = previousType;
        return this;
    }

    @NonNull
    public ScreenView transitionType(@Nullable String transitionType) {
        this.transitionType = transitionType;
        return this;
    }

    @NonNull
    public ScreenView fragmentClassName(@Nullable String fragmentClassName) {
        this.fragmentClassName = fragmentClassName;
        return this;
    }

    @NonNull
    public ScreenView fragmentTag(@Nullable String fragmentTag) {
        this.fragmentTag = fragmentTag;
        return this;
    }

    @NonNull
    public ScreenView activityClassName(@Nullable String activityClassName) {
        this.activityClassName = activityClassName;
        return this;
    }

    @NonNull
    public ScreenView activityTag(@Nullable String activityTag) {
        this.activityTag = activityTag;
        return this;
    }

    @Override
    @NonNull
    public Map<String, Object> getDataPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("id", this.id);
        payload.put("name", this.name);
        if (this.type != null) {
            payload.put("type", this.type);
        }
        if (this.previousId != null) {
            payload.put("previousId", this.previousId);
        }
        if (this.previousName != null) {
            payload.put("previousName", this.previousName);
        }
        if (this.previousType != null) {
            payload.put("previousType", this.previousType);
        }
        if (this.transitionType != null) {
            payload.put("transitionType", this.transitionType);
        }
        return payload;
    }

    @Override
    @NonNull
    public String getSchema() {
        return "iglu:com.snowplowanalytics.mobile/screen_view/jsonschema/1-0-0";
    }

    @Nullable
    private static String getSnowplowScreenId(Activity activity) {
        Class<?> activityClass = activity.getClass();
        try {
            Field field = activityClass.getField("snowplowScreenId");
            Object reflectedValue = field.get(activity);
            if (reflectedValue instanceof String) {
                return (String)reflectedValue;
            }
            Logger.e(TAG, String.format("The value of field `snowplowScreenId` on Activity `%s` has to be a String.", activityClass.getSimpleName()), new Object[0]);
        }
        catch (NoSuchFieldException e) {
            Logger.d(TAG, String.format("Field `snowplowScreenId` not found on Activity `%s`.", activityClass.getSimpleName()), e);
        }
        catch (Exception e) {
            Logger.e(TAG, "Error retrieving value of field `snowplowScreenId`: " + e.getMessage(), e);
        }
        return null;
    }

    @NonNull
    private static String getValidName(@Nullable String s1, @Nullable String s2) {
        if (s1 != null && s1.length() > 0) {
            return s1;
        }
        if (s2 != null && s2.length() > 0) {
            return s2;
        }
        return "Unknown";
    }
}

