/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import androidx.annotation.NonNull;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.internal.utils.Preconditions;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.Map;

public class SelfDescribing
extends AbstractSelfDescribing {
    @NonNull
    public final SelfDescribingJson eventData;
    @NonNull
    private final Map<String, Object> payload;
    @NonNull
    private final String schema;

    public SelfDescribing(@NonNull SelfDescribingJson eventData) {
        Preconditions.checkNotNull(eventData);
        Map<String, Object> eventDataMap = eventData.getMap();
        Preconditions.checkNotNull(eventDataMap);
        Map payload = (Map)eventDataMap.get("data");
        Preconditions.checkNotNull(payload);
        this.payload = payload;
        String schema = (String)eventDataMap.get("schema");
        Preconditions.checkNotNull(schema);
        this.schema = schema;
        this.eventData = eventData;
    }

    public SelfDescribing(@NonNull String schema, @NonNull Map<String, Object> payload) {
        this.schema = schema;
        this.payload = payload;
        this.eventData = new SelfDescribingJson(schema, payload);
    }

    @Override
    @NonNull
    public Map<String, Object> getDataPayload() {
        return this.payload;
    }

    @Override
    @NonNull
    public String getSchema() {
        return this.schema;
    }
}

