/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.AbstractPrimitive;
import com.snowplowanalytics.snowplow.internal.utils.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class Structured
extends AbstractPrimitive {
    @NonNull
    public final String category;
    @NonNull
    public final String action;
    @Nullable
    public String label;
    @Nullable
    public String property;
    @Nullable
    public Double value;

    public Structured(@NonNull String category, @NonNull String action) {
        Preconditions.checkNotNull(category);
        Preconditions.checkNotNull(action);
        Preconditions.checkArgument(!category.isEmpty(), "category cannot be empty");
        Preconditions.checkArgument(!action.isEmpty(), "action cannot be empty");
        this.category = category;
        this.action = action;
    }

    @NonNull
    public Structured label(@Nullable String label) {
        this.label = label;
        return this;
    }

    @NonNull
    public Structured property(@Nullable String property) {
        this.property = property;
        return this;
    }

    @NonNull
    public Structured value(@Nullable Double value) {
        this.value = value;
        return this;
    }

    @Override
    @NonNull
    public Map<String, Object> getDataPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>(5);
        payload.put("se_ca", this.category);
        payload.put("se_ac", this.action);
        if (this.label != null) {
            payload.put("se_la", this.label);
        }
        if (this.property != null) {
            payload.put("se_pr", this.property);
        }
        if (this.value != null) {
            payload.put("se_va", Double.toString(this.value));
        }
        return payload;
    }

    @Override
    @NonNull
    public String getName() {
        return "se";
    }
}

