/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.internal.utils.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class Timing
extends AbstractSelfDescribing {
    @NonNull
    public final String category;
    @NonNull
    public final String variable;
    @NonNull
    public final Integer timing;
    @Nullable
    public String label;

    public Timing(@NonNull String category, @NonNull String variable, @NonNull Integer timing) {
        Preconditions.checkNotNull(category);
        Preconditions.checkNotNull(timing);
        Preconditions.checkNotNull(variable);
        Preconditions.checkArgument(!category.isEmpty(), "category cannot be empty");
        Preconditions.checkArgument(!variable.isEmpty(), "variable cannot be empty");
        this.category = category;
        this.variable = variable;
        this.timing = timing;
    }

    @NonNull
    public Timing label(@Nullable String label) {
        this.label = label;
        return this;
    }

    @Override
    @NonNull
    public Map<String, Object> getDataPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("category", this.category);
        payload.put("variable", this.variable);
        payload.put("timing", this.timing);
        if (this.label != null && !this.label.isEmpty()) {
            payload.put("label", this.label);
        }
        return payload;
    }

    @Override
    @NonNull
    public String getSchema() {
        return "iglu:com.snowplowanalytics.snowplow/timing/jsonschema/1-0-0";
    }
}

