/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.internal.utils.Util;
import java.util.HashMap;
import java.util.Map;

public class TrackerError
extends AbstractSelfDescribing {
    private static final int MAX_MESSAGE_LENGTH = 2048;
    private static final int MAX_STACK_LENGTH = 8192;
    private static final int MAX_EXCEPTION_NAME_LENGTH = 1024;
    private final String source;
    private final String message;
    private final Throwable throwable;

    public TrackerError(@NonNull String source, @NonNull String message) {
        this(source, message, null);
    }

    public TrackerError(@NonNull String source, @NonNull String message, @Nullable Throwable throwable) {
        this.source = source;
        this.message = message;
        this.throwable = throwable;
    }

    @Override
    @NonNull
    public Map<String, Object> getDataPayload() {
        String msg = this.truncate(this.message, 2048);
        if (msg == null || msg.isEmpty()) {
            msg = "Empty message found";
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("className", this.source);
        payload.put("message", msg);
        if (this.throwable != null) {
            String stack = this.truncate(Util.stackTraceToString(this.throwable), 8192);
            String throwableName = this.truncate(this.throwable.getClass().getName(), 1024);
            payload.put("stackTrace", stack);
            payload.put("exceptionName", throwableName);
        }
        return payload;
    }

    @Override
    @NonNull
    public String getSchema() {
        return "iglu:com.snowplowanalytics.snowplow/diagnostic_error/jsonschema/1-0-0";
    }

    private String truncate(String s, int maxLength) {
        if (s == null) {
            return null;
        }
        return s.substring(0, Math.min(s.length(), maxLength));
    }
}

