/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.globalcontexts;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.globalcontexts.ContextGenerator;
import com.snowplowanalytics.snowplow.globalcontexts.FunctionalFilter;
import com.snowplowanalytics.snowplow.globalcontexts.FunctionalGenerator;
import com.snowplowanalytics.snowplow.globalcontexts.SchemaRuleSet;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.InspectableEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GlobalContext {
    @NonNull
    private FunctionalGenerator generator;
    @Nullable
    private FunctionalFilter filter;

    public GlobalContext(final @NonNull ContextGenerator contextGenerator) {
        Objects.requireNonNull(contextGenerator);
        this.generator = new FunctionalGenerator(){

            @Override
            @Nullable
            public List<SelfDescribingJson> apply(@NonNull InspectableEvent event) {
                return contextGenerator.generateContexts(event);
            }
        };
        this.filter = new FunctionalFilter(){

            @Override
            public boolean apply(@NonNull InspectableEvent event) {
                return contextGenerator.filterEvent(event);
            }
        };
    }

    public GlobalContext(final @NonNull List<SelfDescribingJson> staticContexts) {
        Objects.requireNonNull(staticContexts);
        this.generator = new FunctionalGenerator(){

            @Override
            @Nullable
            public List<SelfDescribingJson> apply(@NonNull InspectableEvent event) {
                return staticContexts;
            }
        };
        this.filter = null;
    }

    public GlobalContext(@NonNull FunctionalGenerator generator) {
        this(generator, (FunctionalFilter)null);
    }

    public GlobalContext(final @NonNull List<SelfDescribingJson> staticContexts, @Nullable SchemaRuleSet ruleset) {
        Objects.requireNonNull(staticContexts);
        this.generator = new FunctionalGenerator(){

            @Override
            @Nullable
            public List<SelfDescribingJson> apply(@NonNull InspectableEvent event) {
                return staticContexts;
            }
        };
        this.filter = ruleset.getFilter();
    }

    public GlobalContext(@NonNull FunctionalGenerator generator, @Nullable SchemaRuleSet ruleset) {
        this(generator, ruleset.getFilter());
    }

    public GlobalContext(final @NonNull List<SelfDescribingJson> staticContexts, @Nullable FunctionalFilter filter) {
        Objects.requireNonNull(staticContexts);
        this.generator = new FunctionalGenerator(){

            @Override
            @Nullable
            public List<SelfDescribingJson> apply(@NonNull InspectableEvent event) {
                return staticContexts;
            }
        };
        this.filter = filter;
    }

    public GlobalContext(@NonNull FunctionalGenerator generator, @Nullable FunctionalFilter filter) {
        Objects.requireNonNull(generator);
        this.generator = generator;
        this.filter = filter;
    }

    @NonNull
    public List<SelfDescribingJson> generateContexts(@NonNull InspectableEvent event) {
        if (this.filter != null && !this.filter.apply(event)) {
            return new ArrayList<SelfDescribingJson>();
        }
        return this.generator.apply(event);
    }
}

