/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.globalcontexts;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.globalcontexts.FunctionalFilter;
import com.snowplowanalytics.snowplow.internal.tracker.SchemaRule;
import com.snowplowanalytics.snowplow.tracker.InspectableEvent;
import java.util.ArrayList;
import java.util.List;

public class SchemaRuleSet {
    @NonNull
    private final List<SchemaRule> rulesAllowed = new ArrayList<SchemaRule>();
    @NonNull
    private final List<SchemaRule> rulesDenied = new ArrayList<SchemaRule>();

    private SchemaRuleSet(@Nullable List<String> allowed, @Nullable List<String> denied) {
        SchemaRule schemaRule;
        for (String rule : allowed) {
            schemaRule = SchemaRule.build(rule);
            if (schemaRule == null) continue;
            this.rulesAllowed.add(schemaRule);
        }
        for (String rule : denied) {
            schemaRule = SchemaRule.build(rule);
            if (schemaRule == null) continue;
            this.rulesDenied.add(schemaRule);
        }
    }

    @NonNull
    public static SchemaRuleSet buildRuleSet(@NonNull List<String> allowed, @NonNull List<String> denied) {
        return new SchemaRuleSet(allowed, denied);
    }

    @NonNull
    public static SchemaRuleSet buildRuleSetWithAllowedList(@NonNull List<String> allowed) {
        return SchemaRuleSet.buildRuleSet(allowed, new ArrayList<String>());
    }

    @NonNull
    public static SchemaRuleSet buildRuleSetWithDeniedList(@NonNull List<String> denied) {
        return SchemaRuleSet.buildRuleSet(new ArrayList<String>(), denied);
    }

    @NonNull
    public List<String> getAllowed() {
        ArrayList<String> result = new ArrayList<String>(this.rulesAllowed.size());
        for (SchemaRule schemaRule : this.rulesAllowed) {
            result.add(schemaRule.getRule());
        }
        return result;
    }

    @NonNull
    public List<String> getDenied() {
        ArrayList<String> result = new ArrayList<String>(this.rulesDenied.size());
        for (SchemaRule schemaRule : this.rulesDenied) {
            result.add(schemaRule.getRule());
        }
        return result;
    }

    @NonNull
    public FunctionalFilter getFilter() {
        return new FunctionalFilter(){

            @Override
            public boolean apply(@NonNull InspectableEvent event) {
                return SchemaRuleSet.this.matchWithSchema(event.getSchema());
            }
        };
    }

    public boolean matchWithSchema(@Nullable String schema) {
        if (schema == null) {
            return false;
        }
        for (SchemaRule rule : this.rulesDenied) {
            if (!rule.matchWithSchema(schema)) continue;
            return false;
        }
        if (this.rulesAllowed.size() == 0) {
            return true;
        }
        for (SchemaRule rule : this.rulesAllowed) {
            if (!rule.matchWithSchema(schema)) continue;
            return true;
        }
        return false;
    }
}

