/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.emitter;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.emitter.BufferOption;
import com.snowplowanalytics.snowplow.emitter.EmitterEvent;
import com.snowplowanalytics.snowplow.emitter.EventStore;
import com.snowplowanalytics.snowplow.internal.emitter.Executor;
import com.snowplowanalytics.snowplow.internal.emitter.TLSVersion;
import com.snowplowanalytics.snowplow.internal.emitter.storage.SQLiteEventStore;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.utils.Util;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import com.snowplowanalytics.snowplow.network.NetworkConnection;
import com.snowplowanalytics.snowplow.network.OkHttpNetworkConnection;
import com.snowplowanalytics.snowplow.network.Protocol;
import com.snowplowanalytics.snowplow.network.Request;
import com.snowplowanalytics.snowplow.network.RequestCallback;
import com.snowplowanalytics.snowplow.network.RequestResult;
import com.snowplowanalytics.snowplow.payload.Payload;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;

public class Emitter {
    private final String TAG = Emitter.class.getSimpleName();
    private static final int POST_WRAPPER_BYTES = 88;
    private Context context;
    private RequestCallback requestCallback;
    private HttpMethod httpMethod;
    private BufferOption bufferOption;
    private Protocol requestSecurity;
    private EnumSet<TLSVersion> tlsVersions;
    private String uri;
    private String namespace;
    private int emitterTick;
    private int emptyLimit;
    private int sendLimit;
    private long byteLimitGet;
    private long byteLimitPost;
    private int emitTimeout;
    private TimeUnit timeUnit;
    private String customPostPath;
    private OkHttpClient client;
    private boolean isCustomNetworkConnection;
    private final AtomicReference<NetworkConnection> networkConnection = new AtomicReference();
    private EventStore eventStore;
    private int emptyCount;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private AtomicBoolean isEmittingPaused = new AtomicBoolean(false);

    public Emitter(@NonNull Context context, @NonNull String collectorUri, @Nullable EmitterBuilder builder) {
        this.context = context;
        if (builder == null) {
            builder = new EmitterBuilder();
        }
        this.requestCallback = builder.requestCallback;
        this.bufferOption = builder.bufferOption;
        this.requestSecurity = builder.requestSecurity;
        this.tlsVersions = builder.tlsVersions;
        this.emitterTick = builder.emitterTick;
        this.emptyLimit = builder.emptyLimit;
        this.sendLimit = builder.sendLimit;
        this.byteLimitGet = builder.byteLimitGet;
        this.byteLimitPost = builder.byteLimitPost;
        this.emitTimeout = builder.emitTimeout;
        this.timeUnit = builder.timeUnit;
        this.client = builder.client;
        this.eventStore = builder.eventStore;
        this.uri = collectorUri;
        this.httpMethod = builder.httpMethod;
        this.customPostPath = builder.customPostPath;
        if (builder.networkConnection == null) {
            this.isCustomNetworkConnection = false;
            String endpoint = collectorUri;
            if (!endpoint.startsWith("http")) {
                String protocol = builder.requestSecurity == Protocol.HTTPS ? "https://" : "http://";
                endpoint = protocol + endpoint;
            }
            this.uri = endpoint;
            this.setNetworkConnection(new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(endpoint).method(builder.httpMethod).tls(builder.tlsVersions).emitTimeout(builder.emitTimeout).customPostPath(builder.customPostPath).client(builder.client).build());
        } else {
            this.isCustomNetworkConnection = true;
            this.setNetworkConnection(builder.networkConnection);
        }
        if (builder.threadPoolSize > 2) {
            Executor.setThreadCount(builder.threadPoolSize);
        }
        Logger.v(this.TAG, "Emitter created successfully!", new Object[0]);
    }

    public void add(@NonNull Payload payload) {
        Executor.execute(this.TAG, () -> {
            this.eventStore.add(payload);
            if (this.isRunning.compareAndSet(false, true)) {
                try {
                    this.attemptEmit(this.getNetworkConnection());
                }
                catch (Throwable t) {
                    this.isRunning.set(false);
                    Logger.e(this.TAG, "Received error during emission process: %s", t);
                }
            }
        });
    }

    public void flush() {
        Executor.execute(this.TAG, () -> {
            if (this.isRunning.compareAndSet(false, true)) {
                try {
                    this.attemptEmit(this.getNetworkConnection());
                }
                catch (Throwable t) {
                    this.isRunning.set(false);
                    Logger.e(this.TAG, "Received error during emission process: %s", t);
                }
            }
        });
    }

    public void pauseEmit() {
        this.isEmittingPaused.set(true);
    }

    public void resumeEmit() {
        if (this.isEmittingPaused.compareAndSet(true, false)) {
            this.flush();
        }
    }

    public void shutdown() {
        this.shutdown(0L);
    }

    public boolean shutdown(long timeout) {
        Logger.d(this.TAG, "Shutting down emitter.", new Object[0]);
        this.isRunning.compareAndSet(true, false);
        ExecutorService es = Executor.shutdown();
        if (es == null || timeout <= 0L) {
            return true;
        }
        try {
            boolean isTerminated = es.awaitTermination(timeout, TimeUnit.SECONDS);
            Logger.d(this.TAG, "Executor is terminated: " + isTerminated, new Object[0]);
            return isTerminated;
        }
        catch (InterruptedException e) {
            Logger.e(this.TAG, "Executor termination is interrupted: " + e.getMessage(), new Object[0]);
            return false;
        }
    }

    private void attemptEmit(NetworkConnection networkConnection) {
        if (this.isEmittingPaused.get()) {
            Logger.d(this.TAG, "Emitter paused.", new Object[0]);
            this.isRunning.compareAndSet(true, false);
            return;
        }
        if (!Util.isOnline(this.context)) {
            Logger.d(this.TAG, "Emitter loop stopping: emitter offline.", new Object[0]);
            this.isRunning.compareAndSet(true, false);
            return;
        }
        if (this.eventStore.getSize() <= 0L) {
            if (this.emptyCount >= this.emptyLimit) {
                Logger.d(this.TAG, "Emitter loop stopping: empty limit reached.", new Object[0]);
                this.isRunning.compareAndSet(true, false);
                return;
            }
            ++this.emptyCount;
            Logger.e(this.TAG, "Emitter database empty: " + this.emptyCount, new Object[0]);
            try {
                this.timeUnit.sleep(this.emitterTick);
            }
            catch (InterruptedException e) {
                Logger.e(this.TAG, "Emitter thread sleep interrupted: " + e.toString(), new Object[0]);
            }
            this.attemptEmit(this.getNetworkConnection());
            return;
        }
        this.emptyCount = 0;
        List<EmitterEvent> events = this.eventStore.getEmittableEvents(this.sendLimit);
        List<Request> requests = this.buildRequests(events, networkConnection.getHttpMethod());
        List<RequestResult> results = networkConnection.sendRequests(requests);
        Logger.v(this.TAG, "Processing emitter results.", new Object[0]);
        int successCount = 0;
        int failureCount = 0;
        ArrayList<Long> removableEvents = new ArrayList<Long>();
        for (RequestResult res : results) {
            if (res.getSuccess()) {
                removableEvents.addAll(res.getEventIds());
                successCount += res.getEventIds().size();
                continue;
            }
            failureCount += res.getEventIds().size();
            Logger.e(this.TAG, "Request sending failed but we will retry later.", new Object[0]);
        }
        this.eventStore.removeEvents(removableEvents);
        Logger.d(this.TAG, "Success Count: %s", successCount);
        Logger.d(this.TAG, "Failure Count: %s", failureCount);
        if (this.requestCallback != null) {
            if (failureCount != 0) {
                this.requestCallback.onFailure(successCount, failureCount);
            } else {
                this.requestCallback.onSuccess(successCount);
            }
        }
        if (failureCount > 0 && successCount == 0) {
            if (Util.isOnline(this.context)) {
                Logger.e(this.TAG, "Ensure collector path is valid: %s", networkConnection.getUri());
            }
            Logger.e(this.TAG, "Emitter loop stopping: failures.", new Object[0]);
            this.isRunning.compareAndSet(true, false);
        } else {
            this.attemptEmit(this.getNetworkConnection());
        }
    }

    @NonNull
    protected List<Request> buildRequests(@NonNull List<EmitterEvent> events, HttpMethod httpMethod) {
        ArrayList<Request> requests = new ArrayList<Request>();
        String sendingTime = Util.getTimestamp();
        if (httpMethod == HttpMethod.GET) {
            for (EmitterEvent event : events) {
                Payload payload = event.payload;
                this.addSendingTimeToPayload(payload, sendingTime);
                boolean isOversize = this.isOversize(payload, httpMethod);
                Request request = new Request(payload, event.eventId, isOversize);
                requests.add(request);
            }
        } else {
            for (int i = 0; i < events.size(); i += this.bufferOption.getCode()) {
                ArrayList<Long> reqEventIds = new ArrayList<Long>();
                ArrayList<Payload> postPayloadMaps = new ArrayList<Payload>();
                for (int j = i; j < i + this.bufferOption.getCode() && j < events.size(); ++j) {
                    Request request;
                    EmitterEvent event = events.get(j);
                    Payload payload = event.payload;
                    Long eventId = event.eventId;
                    this.addSendingTimeToPayload(payload, sendingTime);
                    if (this.isOversize(payload, httpMethod)) {
                        request = new Request(payload, eventId, true);
                        requests.add(request);
                        continue;
                    }
                    if (this.isOversize(payload, postPayloadMaps, httpMethod)) {
                        request = new Request(postPayloadMaps, reqEventIds);
                        requests.add(request);
                        postPayloadMaps = new ArrayList();
                        reqEventIds = new ArrayList();
                        postPayloadMaps.add(payload);
                        reqEventIds.add(eventId);
                        continue;
                    }
                    postPayloadMaps.add(payload);
                    reqEventIds.add(eventId);
                }
                if (postPayloadMaps.isEmpty()) continue;
                Request request = new Request(postPayloadMaps, reqEventIds);
                requests.add(request);
            }
        }
        return requests;
    }

    private boolean isOversize(@NonNull Payload payload, HttpMethod httpMethod) {
        return this.isOversize(payload, new ArrayList<Payload>(), httpMethod);
    }

    private boolean isOversize(@NonNull Payload payload, @NonNull List<Payload> previousPaylods, HttpMethod httpMethod) {
        long byteLimit = httpMethod == HttpMethod.GET ? this.byteLimitGet : this.byteLimitPost;
        return this.isOversize(payload, byteLimit, previousPaylods);
    }

    private boolean isOversize(@NonNull Payload payload, long byteLimit, @NonNull List<Payload> previousPaylods) {
        long totalByteSize = payload.getByteSize();
        for (Payload previousPayload : previousPaylods) {
            totalByteSize += previousPayload.getByteSize();
        }
        int wrapperBytes = previousPaylods.size() > 0 ? previousPaylods.size() + 88 : 0;
        return totalByteSize + (long)wrapperBytes > byteLimit;
    }

    private void addSendingTimeToPayload(@NonNull Payload payload, @NonNull String timestamp) {
        payload.add("stm", timestamp);
    }

    @Nullable
    public EventStore getEventStore() {
        return this.eventStore;
    }

    public boolean getEmitterStatus() {
        return this.isRunning.get();
    }

    public void setNamespace(@NonNull String namespace) {
        this.namespace = namespace;
        if (this.eventStore == null) {
            this.eventStore = new SQLiteEventStore(this.context, namespace);
        }
    }

    public void setBufferOption(@NonNull BufferOption option) {
        if (!this.isRunning.get()) {
            this.bufferOption = option;
        }
    }

    public void setSendLimit(int sendLimit) {
        this.sendLimit = sendLimit;
    }

    public void setHttpMethod(@NonNull HttpMethod method) {
        if (!this.isCustomNetworkConnection) {
            this.httpMethod = method;
            this.setNetworkConnection(new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(this.uri).method(this.httpMethod).tls(this.tlsVersions).emitTimeout(this.emitTimeout).customPostPath(this.customPostPath).client(this.client).build());
        }
    }

    public void setRequestSecurity(@NonNull Protocol security) {
        if (!this.isCustomNetworkConnection) {
            this.requestSecurity = security;
            this.setNetworkConnection(new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(this.uri).method(this.httpMethod).tls(this.tlsVersions).emitTimeout(this.emitTimeout).customPostPath(this.customPostPath).client(this.client).build());
        }
    }

    public void setEmitterUri(@NonNull String uri) {
        if (!this.isCustomNetworkConnection) {
            this.uri = uri;
            this.setNetworkConnection(new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(uri).method(this.httpMethod).tls(this.tlsVersions).emitTimeout(this.emitTimeout).customPostPath(this.customPostPath).client(this.client).build());
        }
    }

    public void setCustomPostPath(@Nullable String customPostPath) {
        if (!this.isCustomNetworkConnection) {
            this.customPostPath = customPostPath;
            this.setNetworkConnection(new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(this.uri).method(this.httpMethod).tls(this.tlsVersions).emitTimeout(this.emitTimeout).customPostPath(customPostPath).client(this.client).build());
        }
    }

    public void setEmitTimeout(int emitTimeout) {
        if (!this.isCustomNetworkConnection) {
            this.emitTimeout = emitTimeout;
            this.setNetworkConnection(new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(this.uri).method(this.httpMethod).tls(this.tlsVersions).emitTimeout(emitTimeout).customPostPath(this.customPostPath).client(this.client).build());
        }
    }

    @NonNull
    public String getEmitterUri() {
        return this.getNetworkConnection().getUri().toString();
    }

    @Nullable
    public RequestCallback getRequestCallback() {
        return this.requestCallback;
    }

    public void setRequestCallback(@Nullable RequestCallback requestCallback) {
        this.requestCallback = requestCallback;
    }

    @NonNull
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @NonNull
    public BufferOption getBufferOption() {
        return this.bufferOption;
    }

    @NonNull
    public Protocol getRequestSecurity() {
        return this.requestSecurity;
    }

    @NonNull
    public EnumSet<TLSVersion> getTlsVersions() {
        return this.tlsVersions;
    }

    public int getEmitterTick() {
        return this.emitterTick;
    }

    public int getEmptyLimit() {
        return this.emptyLimit;
    }

    public int getSendLimit() {
        return this.sendLimit;
    }

    public long getByteLimitGet() {
        return this.byteLimitGet;
    }

    public void setByteLimitGet(long byteLimitGet) {
        this.byteLimitGet = byteLimitGet;
    }

    public long getByteLimitPost() {
        return this.byteLimitPost;
    }

    public void setByteLimitPost(long byteLimitPost) {
        this.byteLimitPost = byteLimitPost;
    }

    @Nullable
    public String getCustomPostPath() {
        return this.customPostPath;
    }

    public int getEmitTimeout() {
        return this.emitTimeout;
    }

    @Nullable
    public NetworkConnection getNetworkConnection() {
        return this.networkConnection.get();
    }

    private void setNetworkConnection(@NonNull NetworkConnection networkConnection) {
        this.networkConnection.set(networkConnection);
    }

    public static class EmitterBuilder {
        @Nullable
        RequestCallback requestCallback = null;
        @NonNull
        HttpMethod httpMethod = HttpMethod.POST;
        @NonNull
        BufferOption bufferOption = BufferOption.DefaultGroup;
        @NonNull
        Protocol requestSecurity = Protocol.HTTP;
        @NonNull
        EnumSet<TLSVersion> tlsVersions = EnumSet.of(TLSVersion.TLSv1_2);
        int emitterTick = 5;
        int sendLimit = 250;
        int emptyLimit = 5;
        long byteLimitGet = 40000L;
        long byteLimitPost = 40000L;
        private int emitTimeout = 5;
        int threadPoolSize = 2;
        @NonNull
        TimeUnit timeUnit = TimeUnit.SECONDS;
        @Nullable
        OkHttpClient client = null;
        @Nullable
        String customPostPath = null;
        @Nullable
        NetworkConnection networkConnection = null;
        @Nullable
        EventStore eventStore = null;

        @NonNull
        public EmitterBuilder networkConnection(@Nullable NetworkConnection networkConnection) {
            this.networkConnection = networkConnection;
            return this;
        }

        @NonNull
        public EmitterBuilder eventStore(@Nullable EventStore eventStore) {
            this.eventStore = eventStore;
            return this;
        }

        @NonNull
        public EmitterBuilder method(@NonNull HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @NonNull
        public EmitterBuilder option(@NonNull BufferOption option) {
            this.bufferOption = option;
            return this;
        }

        @NonNull
        public EmitterBuilder security(@NonNull Protocol protocol) {
            this.requestSecurity = protocol;
            return this;
        }

        @NonNull
        public EmitterBuilder tls(@NonNull TLSVersion version) {
            this.tlsVersions = EnumSet.of(version);
            return this;
        }

        @NonNull
        public EmitterBuilder tls(@NonNull EnumSet<TLSVersion> versions) {
            this.tlsVersions = versions;
            return this;
        }

        @NonNull
        public EmitterBuilder callback(@Nullable RequestCallback requestCallback) {
            this.requestCallback = requestCallback;
            return this;
        }

        @NonNull
        public EmitterBuilder tick(int emitterTick) {
            this.emitterTick = emitterTick;
            return this;
        }

        @NonNull
        public EmitterBuilder sendLimit(int sendLimit) {
            this.sendLimit = sendLimit;
            return this;
        }

        @NonNull
        public EmitterBuilder emptyLimit(int emptyLimit) {
            this.emptyLimit = emptyLimit;
            return this;
        }

        @NonNull
        public EmitterBuilder byteLimitGet(long byteLimitGet) {
            this.byteLimitGet = byteLimitGet;
            return this;
        }

        @NonNull
        public EmitterBuilder byteLimitPost(long byteLimitPost) {
            this.byteLimitPost = byteLimitPost;
            return this;
        }

        @NonNull
        public EmitterBuilder emitTimeout(int emitTimeout) {
            this.emitTimeout = emitTimeout;
            return this;
        }

        @NonNull
        public EmitterBuilder timeUnit(@NonNull TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @NonNull
        public EmitterBuilder client(@Nullable OkHttpClient client) {
            this.client = client;
            return this;
        }

        @NonNull
        public EmitterBuilder customPostPath(@Nullable String customPostPath) {
            this.customPostPath = customPostPath;
            return this;
        }

        @NonNull
        public EmitterBuilder threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            return this;
        }
    }
}

