/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.emitter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.controller.EmitterController;
import com.snowplowanalytics.snowplow.emitter.BufferOption;
import com.snowplowanalytics.snowplow.emitter.EventStore;
import com.snowplowanalytics.snowplow.internal.Controller;
import com.snowplowanalytics.snowplow.internal.emitter.Emitter;
import com.snowplowanalytics.snowplow.internal.emitter.EmitterConfigurationUpdate;
import com.snowplowanalytics.snowplow.internal.emitter.Executor;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.tracker.ServiceProviderInterface;
import com.snowplowanalytics.snowplow.network.RequestCallback;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class EmitterControllerImpl
extends Controller
implements EmitterController {
    private static final String TAG = EmitterControllerImpl.class.getSimpleName();

    public EmitterControllerImpl(@NonNull ServiceProviderInterface serviceProvider) {
        super(serviceProvider);
    }

    private Emitter getEmitter() {
        return this.serviceProvider.getTracker().getEmitter();
    }

    @Override
    @Nullable
    public EventStore getEventStore() {
        return this.getEmitter().getEventStore();
    }

    @Override
    @NonNull
    public BufferOption getBufferOption() {
        return this.getEmitter().getBufferOption();
    }

    @Override
    public void setBufferOption(@NonNull BufferOption bufferOption) {
        this.getDirtyConfig().bufferOption = bufferOption;
        this.getDirtyConfig().bufferOptionUpdated = true;
        this.getEmitter().setBufferOption(bufferOption);
    }

    @Override
    public int getEmitRange() {
        return this.getEmitter().getSendLimit();
    }

    @Override
    public void setEmitRange(int emitRange) {
        this.getDirtyConfig().emitRange = emitRange;
        this.getDirtyConfig().emitRangeUpdated = true;
        this.getEmitter().setSendLimit(emitRange);
    }

    @Override
    public int getThreadPoolSize() {
        return Executor.getThreadCount();
    }

    @Override
    public long getByteLimitGet() {
        return this.getEmitter().getByteLimitGet();
    }

    @Override
    public void setByteLimitGet(long byteLimitGet) {
        this.getDirtyConfig().byteLimitGet = byteLimitGet;
        this.getDirtyConfig().byteLimitGetUpdated = true;
        this.getEmitter().setByteLimitGet(byteLimitGet);
    }

    @Override
    public long getByteLimitPost() {
        return this.getEmitter().getByteLimitPost();
    }

    @Override
    public void setByteLimitPost(long byteLimitPost) {
        this.getDirtyConfig().byteLimitPost = byteLimitPost;
        this.getDirtyConfig().byteLimitPostUpdated = true;
        this.getEmitter().setByteLimitPost(byteLimitPost);
    }

    @Override
    @Nullable
    public RequestCallback getRequestCallback() {
        return this.getEmitter().getRequestCallback();
    }

    @Override
    public void setRequestCallback(@Nullable RequestCallback requestCallback) {
        this.getEmitter().setRequestCallback(requestCallback);
    }

    @Override
    public long getDbCount() {
        EventStore eventStore = this.getEmitter().getEventStore();
        if (eventStore == null) {
            Logger.e(TAG, "EventStore not available in the Emitter.", new Object[0]);
            return -1L;
        }
        return eventStore.getSize();
    }

    @Override
    public boolean isSending() {
        return this.getEmitter().getEmitterStatus();
    }

    @Override
    public void pause() {
        this.getDirtyConfig().isPaused = true;
        this.getEmitter().pauseEmit();
    }

    @Override
    public void resume() {
        this.getDirtyConfig().isPaused = false;
        this.getEmitter().resumeEmit();
    }

    @NonNull
    public EmitterConfigurationUpdate getDirtyConfig() {
        return this.serviceProvider.getEmitterConfigurationUpdate();
    }
}

