/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.emitter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class Executor {
    private static ExecutorService executor;
    private static int threadCount;

    private static synchronized ExecutorService getExecutor() {
        if (executor == null) {
            executor = Executors.newScheduledThreadPool(threadCount);
        }
        return executor;
    }

    public static void execute(@Nullable String tag, @Nullable Runnable runnable) {
        Executor.execute(false, tag, runnable);
    }

    public static void execute(boolean reportsOnDiagnostic, @Nullable String tag, @Nullable Runnable runnable) {
        String loggerTag = tag == null ? "Source not provided" : tag;
        Executor.execute(runnable, (Throwable t) -> {
            String message = t.getLocalizedMessage();
            if (message == null) {
                message = "No message provided.";
            }
            if (reportsOnDiagnostic) {
                Logger.track(loggerTag, message, t);
            } else {
                Logger.e(loggerTag, message, t);
            }
        });
    }

    public static void execute(@Nullable Runnable runnable, @Nullable ExceptionHandler exceptionHandler) {
        block2: {
            ExecutorService executor = Executor.getExecutor();
            try {
                executor.execute(() -> {
                    block3: {
                        try {
                            if (runnable != null) {
                                runnable.run();
                            }
                        }
                        catch (Throwable t) {
                            if (exceptionHandler == null) break block3;
                            exceptionHandler.handle(t);
                        }
                    }
                });
            }
            catch (Exception e) {
                if (exceptionHandler == null) break block2;
                exceptionHandler.handle(e);
            }
        }
    }

    @NonNull
    public static Future<?> futureCallable(@NonNull Callable<?> callable) {
        return Executor.getExecutor().submit(callable);
    }

    @Nullable
    public static ExecutorService shutdown() {
        if (executor != null) {
            executor.shutdown();
            ExecutorService es = executor;
            executor = null;
            return es;
        }
        return null;
    }

    public static void setThreadCount(int count) {
        if (count >= 2) {
            threadCount = count;
        }
    }

    public static int getThreadCount() {
        return threadCount;
    }

    static {
        threadCount = 2;
    }

    @FunctionalInterface
    public static interface ExceptionHandler {
        public void handle(@Nullable Throwable var1);
    }
}

