/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.emitter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.controller.NetworkController;
import com.snowplowanalytics.snowplow.internal.Controller;
import com.snowplowanalytics.snowplow.internal.emitter.Emitter;
import com.snowplowanalytics.snowplow.internal.emitter.NetworkConfigurationUpdate;
import com.snowplowanalytics.snowplow.internal.tracker.ServiceProviderInterface;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import com.snowplowanalytics.snowplow.network.NetworkConnection;
import com.snowplowanalytics.snowplow.network.OkHttpNetworkConnection;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class NetworkControllerImpl
extends Controller
implements NetworkController {
    public NetworkControllerImpl(@NonNull ServiceProviderInterface serviceProvider) {
        super(serviceProvider);
    }

    public boolean isCustomNetworkConnection() {
        NetworkConnection networkConnection = this.getEmitter().getNetworkConnection();
        return networkConnection != null && !(networkConnection instanceof OkHttpNetworkConnection);
    }

    @Override
    public void setEndpoint(@NonNull String endpoint) {
        this.getEmitter().setEmitterUri(endpoint);
    }

    @Override
    @NonNull
    public String getEndpoint() {
        return this.getEmitter().getEmitterUri();
    }

    @Override
    public void setMethod(@NonNull HttpMethod method) {
        this.getEmitter().setHttpMethod(method);
    }

    @Override
    @NonNull
    public HttpMethod getMethod() {
        return this.getEmitter().getHttpMethod();
    }

    @Override
    public void setCustomPostPath(@Nullable String customPostPath) {
        this.getDirtyConfig().customPostPath = customPostPath;
        this.getDirtyConfig().customPostPathUpdated = true;
        this.getEmitter().setCustomPostPath(customPostPath);
    }

    @Override
    @Nullable
    public String getCustomPostPath() {
        return this.getEmitter().getCustomPostPath();
    }

    @Override
    public void setTimeout(int timeout) {
        this.getEmitter().setEmitTimeout(timeout);
    }

    @Override
    public int getTimeout() {
        return this.getEmitter().getEmitTimeout();
    }

    private Emitter getEmitter() {
        return this.serviceProvider.getEmitter();
    }

    private NetworkConfigurationUpdate getDirtyConfig() {
        return this.serviceProvider.getNetworkConfigurationUpdate();
    }
}

