/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.emitter;

import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.internal.emitter.TLSSocketFactory;
import com.snowplowanalytics.snowplow.internal.emitter.TLSVersion;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.EnumSet;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class TLSArguments {
    private X509TrustManager trustManager = null;
    private SSLSocketFactory sslSocketFactory = null;
    private EnumSet<TLSVersion> tlsVersions;

    public TLSArguments(EnumSet<TLSVersion> versions) {
        this.tlsVersions = versions;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            this.trustManager = (X509TrustManager)trustManagers[0];
            this.sslSocketFactory = new TLSSocketFactory(this.getVersions());
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public String[] getVersions() {
        String[] acceptedVersions = new String[this.tlsVersions.size()];
        int i = 0;
        for (TLSVersion version : this.tlsVersions) {
            acceptedVersions[i] = version.toString();
            ++i;
        }
        return acceptedVersions;
    }
}

