/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.emitter.storage;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class EventStoreHelper
extends SQLiteOpenHelper {
    public static final String TABLE_EVENTS = "events";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_EVENT_DATA = "eventData";
    public static final String COLUMN_DATE_CREATED = "dateCreated";
    public static final String METADATA_ID = "id";
    public static final String METADATA_EVENT_DATA = "eventData";
    public static final String METADATA_DATE_CREATED = "dateCreated";
    private static final String DATABASE_NAME = "snowplowEvents";
    private static final String TAG = EventStoreHelper.class.getName();
    private static final int DATABASE_VERSION = 1;
    private static final String queryDropTable = "DROP TABLE IF EXISTS 'events'";
    private static final String queryCreateTable = "CREATE TABLE IF NOT EXISTS 'events' (id INTEGER PRIMARY KEY, eventData BLOB, dateCreated TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
    private static HashMap<String, EventStoreHelper> instances = new HashMap();

    @NonNull
    public static synchronized List<String> removeUnsentEventsExceptForNamespaces(@NonNull Context context, @Nullable List<String> allowedNamespaces) {
        String[] databaseList;
        if (allowedNamespaces == null) {
            allowedNamespaces = new ArrayList<String>();
        }
        if ((databaseList = context.databaseList()) == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> allowedDbFiles = new ArrayList<String>(allowedNamespaces.size());
        for (String namespace : allowedNamespaces) {
            String sqliteSuffix = namespace.replaceAll("[^a-zA-Z0-9_]+", "-");
            String dbName = "snowplowEvents-" + sqliteSuffix + ".sqlite";
            allowedDbFiles.add(dbName);
            allowedDbFiles.add(dbName + "-wal");
            allowedDbFiles.add(dbName + "-shm");
        }
        ArrayList<String> removedDbFiles = new ArrayList<String>();
        for (String dbName : databaseList) {
            if (!dbName.startsWith(DATABASE_NAME) || allowedDbFiles.contains(dbName) || !context.deleteDatabase(dbName)) continue;
            removedDbFiles.add(dbName);
        }
        return removedDbFiles;
    }

    @NonNull
    public static synchronized EventStoreHelper getInstance(@NonNull Context context, @NonNull String namespace) {
        if (instances.containsKey(namespace)) {
            return instances.get(namespace);
        }
        String sqliteSuffix = namespace.replaceAll("[^a-zA-Z0-9_]+", "-");
        String dbName = "snowplowEvents-" + sqliteSuffix + ".sqlite";
        EventStoreHelper.renameLegacyDatabase(context, dbName);
        EventStoreHelper eventStoreHelper = new EventStoreHelper(context.getApplicationContext(), dbName);
        instances.put(namespace, eventStoreHelper);
        return eventStoreHelper;
    }

    @Nullable
    public static synchronized EventStoreHelper removeInstance(@NonNull String namespace) {
        return instances.remove(namespace);
    }

    private static boolean renameLegacyDatabase(@NonNull Context context, String newDatabaseFilename) {
        File database = context.getDatabasePath("snowplowEvents.sqlite");
        File databaseWal = context.getDatabasePath("snowplowEvents.sqlite-wal");
        File databaseShm = context.getDatabasePath("snowplowEvents.sqlite-shm");
        File parentFile = database.getParentFile();
        File newDatabase = new File(parentFile, newDatabaseFilename);
        File newDatabaseWal = new File(parentFile, newDatabaseFilename + "-wal");
        File newDatabaseShm = new File(parentFile, newDatabaseFilename + "-shm");
        return database.renameTo(newDatabase) && databaseWal.renameTo(newDatabaseWal) && databaseShm.renameTo(newDatabaseShm);
    }

    private EventStoreHelper(Context context, String databaseName) {
        super(context, databaseName, null, 1);
    }

    public void onCreate(@NonNull SQLiteDatabase database) {
        database.execSQL(queryCreateTable);
    }

    public void onUpgrade(@NonNull SQLiteDatabase database, int oldVersion, int newVersion) {
        Logger.d(TAG, "Upgrade not implemented, resetting database...", new Object[0]);
        database.execSQL(queryDropTable);
        this.onCreate(database);
    }
}

