/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.emitter.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.emitter.EmitterEvent;
import com.snowplowanalytics.snowplow.emitter.EventStore;
import com.snowplowanalytics.snowplow.internal.emitter.Executor;
import com.snowplowanalytics.snowplow.internal.emitter.storage.EventStoreHelper;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.utils.Util;
import com.snowplowanalytics.snowplow.payload.Payload;
import com.snowplowanalytics.snowplow.payload.TrackerPayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLiteEventStore
implements EventStore {
    private static final String TAG = SQLiteEventStore.class.getSimpleName();
    private final List<Payload> payloadWaitingList = new ArrayList<Payload>();
    private final String namespace;
    private SQLiteDatabase database;
    private EventStoreHelper dbHelper;
    private final String[] allColumns = new String[]{"id", "eventData", "dateCreated"};
    private long lastInsertedRowId = -1L;

    @NonNull
    public static List<String> removeUnsentEventsExceptForNamespaces(@NonNull Context context, @Nullable List<String> allowedNamespaces) {
        return EventStoreHelper.removeUnsentEventsExceptForNamespaces(context, allowedNamespaces);
    }

    public SQLiteEventStore(@NonNull Context context, @NonNull String namespace) {
        this.namespace = namespace;
        Executor.futureCallable(() -> {
            this.dbHelper = EventStoreHelper.getInstance(context, namespace);
            this.open();
            Logger.d(TAG, "DB Path: %s", this.database.getPath());
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(@NonNull Payload payload) {
        if (!this.isDatabaseOpen()) {
            SQLiteEventStore sQLiteEventStore = this;
            synchronized (sQLiteEventStore) {
                this.payloadWaitingList.add(payload);
            }
        } else {
            this.insertWaitingEventsIfReady();
            this.insertEvent(payload);
        }
    }

    public void open() {
        if (!this.isDatabaseOpen()) {
            this.database = this.dbHelper.getWritableDatabase();
            this.database.enableWriteAheadLogging();
        }
    }

    public void close() {
        this.dbHelper.close();
        EventStoreHelper.removeInstance(this.namespace);
    }

    public long insertEvent(@NonNull Payload payload) {
        if (this.isDatabaseOpen()) {
            byte[] bytes = Util.serialize(payload.getMap());
            ContentValues values = new ContentValues(2);
            values.put("eventData", bytes);
            this.lastInsertedRowId = this.database.insert("events", null, values);
        }
        Logger.d(TAG, "Added event to database: %s", this.lastInsertedRowId);
        return this.lastInsertedRowId;
    }

    @Override
    public boolean removeEvent(long id) {
        int retval = -1;
        if (this.isDatabaseOpen()) {
            retval = this.database.delete("events", "id=" + id, null);
        }
        Logger.d(TAG, "Removed event from database: %s", "" + id);
        return retval == 1;
    }

    @Override
    public boolean removeEvents(@NonNull List<Long> ids) {
        if (ids.size() == 0) {
            return false;
        }
        int retval = -1;
        if (this.isDatabaseOpen()) {
            retval = this.database.delete("events", "id in (" + Util.joinLongList(ids) + ")", null);
        }
        Logger.d(TAG, "Removed events from database: %s", retval);
        return retval == ids.size();
    }

    @Override
    public boolean removeAllEvents() {
        int retval = 0;
        Logger.d(TAG, "Removing all events from database.", new Object[0]);
        if (this.isDatabaseOpen()) {
            retval = this.database.delete("events", null, null);
        } else {
            Logger.e(TAG, "Database is not open.", new Object[0]);
        }
        this.payloadWaitingList.clear();
        return (retval += this.payloadWaitingList.size()) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private List<Map<String, Object>> queryDatabase(String query, String orderBy) {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        if (this.isDatabaseOpen()) {
            try (Cursor cursor = null;){
                cursor = this.database.query("events", this.allColumns, query, null, null, null, orderBy);
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    HashMap<String, Object> eventMetadata = new HashMap<String, Object>();
                    eventMetadata.put("id", cursor.getLong(0));
                    eventMetadata.put("eventData", Util.deserializer(cursor.getBlob(1)));
                    eventMetadata.put("dateCreated", cursor.getString(2));
                    cursor.moveToNext();
                    res.add(eventMetadata);
                }
            }
        }
        return res;
    }

    @Override
    public long getSize() {
        if (this.isDatabaseOpen()) {
            this.insertWaitingEventsIfReady();
            return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)"events");
        }
        return this.payloadWaitingList.size();
    }

    public long getLastInsertedRowId() {
        return this.lastInsertedRowId;
    }

    @Override
    @NonNull
    public List<EmitterEvent> getEmittableEvents(int queryLimit) {
        if (!this.isDatabaseOpen()) {
            return Collections.emptyList();
        }
        this.insertWaitingEventsIfReady();
        ArrayList<EmitterEvent> events = new ArrayList<EmitterEvent>();
        for (Map<String, Object> eventMetadata : this.getDescEventsInRange(queryLimit)) {
            TrackerPayload payload = new TrackerPayload();
            Map eventData = (Map)eventMetadata.get("eventData");
            payload.addMap(eventData);
            Long eventId = (Long)eventMetadata.get("id");
            if (eventId == null) {
                Logger.e(TAG, "Unable to get ID of an event extracted from the database.", new Object[0]);
                continue;
            }
            EmitterEvent event = new EmitterEvent(payload, eventId);
            events.add(event);
        }
        return events;
    }

    @Nullable
    public Map<String, Object> getEvent(long id) {
        List<Map<String, Object>> res = this.queryDatabase("id=" + id, null);
        if (!res.isEmpty()) {
            return res.get(0);
        }
        return null;
    }

    @NonNull
    public List<Map<String, Object>> getAllEvents() {
        return this.queryDatabase(null, null);
    }

    @NonNull
    public List<Map<String, Object>> getDescEventsInRange(int range) {
        return this.queryDatabase(null, "id DESC LIMIT " + range);
    }

    public boolean isDatabaseOpen() {
        return this.database != null && this.database.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertWaitingEventsIfReady() {
        if (this.isDatabaseOpen() && this.payloadWaitingList.size() > 0) {
            SQLiteEventStore sQLiteEventStore = this;
            synchronized (sQLiteEventStore) {
                for (Payload p : this.payloadWaitingList) {
                    this.insertEvent(p);
                }
                this.payloadWaitingList.clear();
            }
        }
    }
}

