/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.gdpr;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.controller.GdprController;
import com.snowplowanalytics.snowplow.internal.Controller;
import com.snowplowanalytics.snowplow.internal.gdpr.Gdpr;
import com.snowplowanalytics.snowplow.internal.gdpr.GdprConfigurationUpdate;
import com.snowplowanalytics.snowplow.internal.tracker.ServiceProviderInterface;
import com.snowplowanalytics.snowplow.internal.tracker.Tracker;
import com.snowplowanalytics.snowplow.util.Basis;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class GdprControllerImpl
extends Controller
implements GdprController {
    @Nullable
    private Gdpr gdpr;
    @Nullable
    private Basis basisForProcessing;
    @Nullable
    private String documentId;
    @Nullable
    private String documentVersion;
    @Nullable
    private String documentDescription;

    public GdprControllerImpl(@NonNull ServiceProviderInterface serviceProvider) {
        super(serviceProvider);
    }

    @Override
    public void reset(@NonNull Basis basisForProcessing, @NonNull String documentId, @NonNull String documentVersion, @NonNull String documentDescription) {
        this.getTracker().enableGdprContext(basisForProcessing, documentId, documentVersion, documentDescription);
        this.getDirtyConfig().gdpr = this.gdpr = this.getTracker().getGdprContext();
        this.getDirtyConfig().gdprUpdated = true;
    }

    @Override
    public boolean isEnabled() {
        return this.getTracker().getGdprContext() != null;
    }

    @Override
    public boolean enable() {
        if (this.gdpr == null) {
            return false;
        }
        this.getTracker().enableGdprContext(this.gdpr.basisForProcessing, this.gdpr.documentId, this.gdpr.documentVersion, this.gdpr.documentDescription);
        this.getDirtyConfig().isEnabled = true;
        return true;
    }

    @Override
    public void disable() {
        this.getDirtyConfig().isEnabled = false;
        this.getTracker().disableGdprContext();
    }

    @Override
    @Nullable
    public Basis getBasisForProcessing() {
        if (this.gdpr == null) {
            return null;
        }
        return this.gdpr.basisForProcessing;
    }

    @Override
    @Nullable
    public String getDocumentId() {
        if (this.gdpr == null) {
            return null;
        }
        return this.gdpr.documentId;
    }

    @Override
    @Nullable
    public String getDocumentVersion() {
        if (this.gdpr == null) {
            return null;
        }
        return this.gdpr.documentVersion;
    }

    @Override
    @Nullable
    public String getDocumentDescription() {
        if (this.gdpr == null) {
            return null;
        }
        return this.gdpr.documentDescription;
    }

    @NonNull
    private Tracker getTracker() {
        return this.serviceProvider.getTracker();
    }

    @NonNull
    private GdprConfigurationUpdate getDirtyConfig() {
        return this.serviceProvider.getGdprConfigurationUpdate();
    }
}

