/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.remoteconfiguration;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.configuration.NetworkConfiguration;
import com.snowplowanalytics.snowplow.configuration.SessionConfiguration;
import com.snowplowanalytics.snowplow.configuration.SubjectConfiguration;
import com.snowplowanalytics.snowplow.configuration.TrackerConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigurationBundle
implements Configuration {
    @NonNull
    public final String namespace;
    @Nullable
    public NetworkConfiguration networkConfiguration;
    @Nullable
    public TrackerConfiguration trackerConfiguration;
    @Nullable
    public SubjectConfiguration subjectConfiguration;
    @Nullable
    public SessionConfiguration sessionConfiguration;

    ConfigurationBundle(@NonNull String namespace) {
        this(namespace, null);
    }

    ConfigurationBundle(@NonNull String namespace, @Nullable NetworkConfiguration networkConfiguration) {
        this.namespace = namespace;
        this.networkConfiguration = networkConfiguration;
    }

    public ConfigurationBundle(@NonNull Context context, @NonNull JSONObject jsonObject) throws JSONException {
        this(jsonObject.getString("namespace"));
        JSONObject json = jsonObject.optJSONObject("networkConfiguration");
        if (json != null) {
            this.networkConfiguration = new NetworkConfiguration(json);
        }
        if ((json = jsonObject.optJSONObject("trackerConfiguration")) != null) {
            this.trackerConfiguration = new TrackerConfiguration(context.getPackageName(), json);
        }
        if ((json = jsonObject.optJSONObject("subjectConfiguration")) != null) {
            this.subjectConfiguration = new SubjectConfiguration(json);
        }
        if ((json = jsonObject.optJSONObject("sessionConfiguration")) != null) {
            this.sessionConfiguration = new SessionConfiguration(json);
        }
    }

    @NonNull
    public List<Configuration> getConfigurations() {
        ArrayList<Configuration> array = new ArrayList<Configuration>();
        if (this.networkConfiguration != null) {
            array.add(this.networkConfiguration);
        }
        if (this.trackerConfiguration != null) {
            array.add(this.trackerConfiguration);
        }
        if (this.subjectConfiguration != null) {
            array.add(this.subjectConfiguration);
        }
        if (this.sessionConfiguration != null) {
            array.add(this.sessionConfiguration);
        }
        return array;
    }

    @Override
    @NonNull
    public Configuration copy() {
        ConfigurationBundle copy = new ConfigurationBundle(this.namespace);
        copy.networkConfiguration = this.networkConfiguration;
        copy.trackerConfiguration = this.trackerConfiguration;
        copy.subjectConfiguration = this.subjectConfiguration;
        copy.sessionConfiguration = this.sessionConfiguration;
        return copy;
    }
}

