/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.remoteconfiguration;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.internal.remoteconfiguration.FetchedConfigurationBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ConfigurationCache {
    @Nullable
    private String cacheFilePath;
    @Nullable
    private FetchedConfigurationBundle configuration;

    @Nullable
    public synchronized FetchedConfigurationBundle readCache(@NonNull Context context) {
        if (this.configuration != null) {
            return this.configuration;
        }
        this.loadCache(context);
        return this.configuration;
    }

    public synchronized void writeCache(@NonNull Context context, @NonNull FetchedConfigurationBundle configuration) {
        this.configuration = configuration;
        this.storeCache(context, configuration);
    }

    public synchronized void clearCache(@NonNull Context context) {
        String path = this.getCachePath(context);
        File file = new File(path);
        file.delete();
    }

    private String getCachePath(@NonNull Context context) {
        if (this.cacheFilePath != null) {
            return this.cacheFilePath;
        }
        String cacheDirPath = context.getCacheDir().getAbsolutePath() + File.separator + "snowplow-cache";
        File cacheDir = new File(cacheDirPath);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        this.cacheFilePath = cacheDir.getAbsolutePath() + File.separator + "remoteConfig.data";
        return this.cacheFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache(@NonNull Context context) {
        String path = this.getCachePath(context);
        ObjectInputStream objectIn = null;
        try {
            FileInputStream fileIn = new FileInputStream(path);
            objectIn = new ObjectInputStream(fileIn);
            this.configuration = (FetchedConfigurationBundle)objectIn.readObject();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            if (objectIn != null) {
                try {
                    objectIn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCache(@NonNull Context context, @NonNull FetchedConfigurationBundle configuration) {
        String path = this.getCachePath(context);
        ObjectOutputStream objectOut = null;
        try {
            FileOutputStream fileOut = new FileOutputStream(path, false);
            objectOut = new ObjectOutputStream(fileOut);
            objectOut.writeObject(configuration);
            fileOut.getFD().sync();
        }
        catch (IOException iOException) {
        }
        finally {
            if (objectOut != null) {
                try {
                    objectOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

