/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.remoteconfiguration;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import com.snowplowanalytics.snowplow.configuration.RemoteConfiguration;
import com.snowplowanalytics.snowplow.internal.remoteconfiguration.ConfigurationBundle;
import com.snowplowanalytics.snowplow.internal.remoteconfiguration.ConfigurationCache;
import com.snowplowanalytics.snowplow.internal.remoteconfiguration.ConfigurationFetcher;
import com.snowplowanalytics.snowplow.internal.remoteconfiguration.FetchedConfigurationBundle;
import java.util.List;

public class ConfigurationProvider {
    @NonNull
    private RemoteConfiguration remoteConfiguration;
    @NonNull
    private ConfigurationCache cache;
    @Nullable
    private ConfigurationFetcher fetcher;
    @Nullable
    private FetchedConfigurationBundle defaultBundle;
    @Nullable
    private FetchedConfigurationBundle cacheBundle;

    public ConfigurationProvider(@NonNull RemoteConfiguration remoteConfiguration) {
        this(remoteConfiguration, null);
    }

    public ConfigurationProvider(@NonNull RemoteConfiguration remoteConfiguration, @Nullable List<ConfigurationBundle> defaultBundles) {
        this.remoteConfiguration = remoteConfiguration;
        this.cache = new ConfigurationCache();
        if (defaultBundles != null) {
            FetchedConfigurationBundle bundle = new FetchedConfigurationBundle("1.0");
            bundle.configurationVersion = Integer.MIN_VALUE;
            bundle.configurationBundle = defaultBundles;
            this.defaultBundle = bundle;
        }
    }

    public synchronized void retrieveConfiguration(final @NonNull Context context, boolean onlyRemote, final @NonNull Consumer<FetchedConfigurationBundle> onFetchCallback) {
        if (!onlyRemote) {
            FetchedConfigurationBundle retrievedBundle;
            if (this.cacheBundle == null) {
                this.cacheBundle = this.cache.readCache(context);
            }
            FetchedConfigurationBundle fetchedConfigurationBundle = retrievedBundle = this.cacheBundle != null ? this.cacheBundle : this.defaultBundle;
            if (retrievedBundle != null) {
                onFetchCallback.accept((Object)retrievedBundle);
            }
        }
        this.fetcher = new ConfigurationFetcher(context, this.remoteConfiguration, new Consumer<FetchedConfigurationBundle>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(FetchedConfigurationBundle fetchedConfigurationBundle) {
                if (!ConfigurationProvider.this.schemaCompatibility(fetchedConfigurationBundle.schema)) {
                    return;
                }
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (ConfigurationProvider.this.cacheBundle != null && ((ConfigurationProvider)ConfigurationProvider.this).cacheBundle.configurationVersion >= fetchedConfigurationBundle.configurationVersion) {
                        return;
                    }
                    ConfigurationProvider.this.cache.writeCache(context, fetchedConfigurationBundle);
                    ConfigurationProvider.this.cacheBundle = fetchedConfigurationBundle;
                    onFetchCallback.accept((Object)fetchedConfigurationBundle);
                }
            }
        });
    }

    private boolean schemaCompatibility(@NonNull String schema) {
        return schema.startsWith("http://iglucentral.com/schemas/com.snowplowanalytics.mobile/remote_config/jsonschema/1-");
    }
}

