/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.remoteconfiguration;

import android.content.Context;
import androidx.annotation.NonNull;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.internal.remoteconfiguration.ConfigurationBundle;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchedConfigurationBundle
implements Configuration {
    @NonNull
    public String schema;
    public int configurationVersion;
    @NonNull
    public List<ConfigurationBundle> configurationBundle;

    FetchedConfigurationBundle(@NonNull String schema) {
        this.schema = schema;
        this.configurationVersion = -1;
        this.configurationBundle = new ArrayList<ConfigurationBundle>();
    }

    public FetchedConfigurationBundle(@NonNull Context context, @NonNull JSONObject jsonObject) throws JSONException {
        this.schema = jsonObject.getString("$schema");
        this.configurationVersion = jsonObject.getInt("configurationVersion");
        this.configurationBundle = new ArrayList<ConfigurationBundle>();
        JSONArray array = jsonObject.getJSONArray("configurationBundle");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject bundleJson = array.getJSONObject(i);
            ConfigurationBundle bundle = new ConfigurationBundle(context, bundleJson);
            this.configurationBundle.add(bundle);
        }
    }

    @Override
    @NonNull
    public Configuration copy() {
        FetchedConfigurationBundle copy = new FetchedConfigurationBundle(this.schema);
        copy.configurationVersion = this.configurationVersion;
        for (ConfigurationBundle bundle : this.configurationBundle) {
            copy.configurationBundle.add((ConfigurationBundle)bundle.copy());
        }
        return copy;
    }
}

