/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.session;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class FileStore {
    private static final String TAG = FileStore.class.getSimpleName();

    public static boolean saveMapToFile(@NonNull String filename, @NonNull Map objects, @NonNull Context context) {
        try {
            Logger.d(TAG, "Attempting to save: %s", objects);
            FileOutputStream fos = context.openFileOutput(filename, 0);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(objects);
            oos.close();
            Logger.d(TAG, " + Successfully saved KV Pairs to: %s", filename);
            return true;
        }
        catch (IOException | NullPointerException ioe) {
            Logger.e(TAG, " + Exception saving vars map: %s", ioe.getMessage());
            return false;
        }
    }

    @Nullable
    public static synchronized Map<String, Object> getMapFromFile(@NonNull String filename, @NonNull Context context) {
        try {
            File file = context.getFileStreamPath(filename);
            if (file == null || !file.exists()) {
                return null;
            }
            Logger.d(TAG, "Attempting to retrieve map from: %s", filename);
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            HashMap varsMap = (HashMap)ois.readObject();
            ois.close();
            Logger.d(TAG, " + Retrieved map from file: %s", varsMap);
            return varsMap;
        }
        catch (IOException | ClassNotFoundException ioe) {
            Logger.e(TAG, " + Exception getting vars map: %s", ioe.getMessage());
            return null;
        }
    }

    public static boolean deleteFile(@NonNull String filename, @NonNull Context context) {
        boolean isSuccess = context.deleteFile(filename);
        Logger.d(TAG, "Deleted %s from internal storage: %s", filename, isSuccess);
        return isSuccess;
    }
}

