/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.session;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.utils.NotificationCenter;
import java.util.HashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@TargetApi(value=14)
public class ProcessObserver
implements LifecycleObserver {
    private static final String TAG = ProcessObserver.class.getSimpleName();
    private static InitializationState initializationState = InitializationState.NONE;

    public static synchronized void initialize(@NonNull Context context) {
        if (initializationState == InitializationState.NONE) {
            initializationState = InitializationState.IN_PROGRESS;
            Handler mainHandler = new Handler(context.getMainLooper());
            mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)new ProcessObserver());
                        initializationState = InitializationState.COMPLETE;
                    }
                    catch (NoClassDefFoundError e) {
                        initializationState = InitializationState.NONE;
                        Logger.e(TAG, "Class 'ProcessLifecycleOwner' not found. The tracker can't track lifecycle events.", new Object[0]);
                    }
                }
            });
        }
    }

    private ProcessObserver() {
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onEnterForeground() {
        Logger.d(TAG, "App enter foreground", new Object[0]);
        try {
            HashMap<String, Object> notificationData = new HashMap<String, Object>();
            notificationData.put("isForeground", Boolean.TRUE);
            NotificationCenter.postNotification("SnowplowLifecycleTracking", notificationData);
        }
        catch (Exception e) {
            Logger.e(TAG, "Method onEnterForeground raised an exception: %s", e);
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onEnterBackground() {
        Logger.d(TAG, "App enter background", new Object[0]);
        try {
            HashMap<String, Object> notificationData = new HashMap<String, Object>();
            notificationData.put("isForeground", Boolean.FALSE);
            NotificationCenter.postNotification("SnowplowLifecycleTracking", notificationData);
        }
        catch (Exception e) {
            Logger.e(TAG, "Method onEnterBackground raised an exception: %s", e);
        }
    }

    private static enum InitializationState {
        NONE,
        IN_PROGRESS,
        COMPLETE;

    }
}

