/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.session;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.StrictMode;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import com.snowplowanalytics.snowplow.internal.session.FileStore;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.utils.Util;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.SessionState;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class Session {
    private static final String TAG = Session.class.getSimpleName();
    private String userId;
    private volatile int backgroundIndex = 0;
    private volatile int foregroundIndex = 0;
    private SessionState state = null;
    private final AtomicBoolean isBackground = new AtomicBoolean(false);
    private long lastSessionCheck;
    private final AtomicBoolean isNewSession = new AtomicBoolean(true);
    private volatile boolean isSessionCheckerEnabled;
    private long foregroundTimeout;
    private long backgroundTimeout;
    private Runnable foregroundTransitionCallback = null;
    private Runnable backgroundTransitionCallback = null;
    private Runnable foregroundTimeoutCallback = null;
    private Runnable backgroundTimeoutCallback = null;
    @Nullable
    public Consumer<SessionState> onSessionUpdate;
    private SharedPreferences sharedPreferences;

    @NonNull
    public static synchronized Session getInstance(@NonNull Context context, long foregroundTimeout, long backgroundTimeout, @NonNull TimeUnit timeUnit, @Nullable String namespace, @Nullable Runnable[] sessionCallbacks) {
        Session session = new Session(foregroundTimeout, backgroundTimeout, timeUnit, namespace, context);
        Runnable[] callbacks = new Runnable[]{null, null, null, null};
        if (sessionCallbacks.length == 4) {
            callbacks = sessionCallbacks;
        }
        session.foregroundTransitionCallback = callbacks[0];
        session.backgroundTransitionCallback = callbacks[1];
        session.foregroundTimeoutCallback = callbacks[2];
        session.backgroundTimeoutCallback = callbacks[3];
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ApplySharedPref"})
    public Session(long foregroundTimeout, long backgroundTimeout, @NonNull TimeUnit timeUnit, @Nullable String namespace, @NonNull Context context) {
        this.foregroundTimeout = timeUnit.toMillis(foregroundTimeout);
        this.backgroundTimeout = timeUnit.toMillis(backgroundTimeout);
        this.isSessionCheckerEnabled = true;
        String sessionVarsName = "snowplow_session_vars";
        if (namespace != null && !namespace.isEmpty()) {
            String sessionVarsSuffix = namespace.replaceAll("[^a-zA-Z0-9_]+", "-");
            sessionVarsName = "snowplow_session_vars_" + sessionVarsSuffix;
        }
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            Map<String, Object> sessionInfo = this.getSessionMapFromLegacyTrackerV3(context, sessionVarsName);
            if (sessionInfo == null && (sessionInfo = this.getSessionMapFromLegacyTrackerV2(context, sessionVarsName)) == null) {
                try {
                    sessionInfo = this.getSessionMapFromLegacyTrackerV1(context);
                }
                catch (Exception e) {
                    Logger.track(TAG, String.format("Exception occurred retrieving session info from file: %s", e), e);
                }
            }
            if (sessionInfo == null) {
                Logger.track(TAG, "No previous session info available", new Object[0]);
            } else {
                this.state = SessionState.build(sessionInfo);
            }
            this.userId = Session.retrieveUserId(context, this.state);
            this.sharedPreferences = context.getSharedPreferences(sessionVarsName, 0);
            this.lastSessionCheck = System.currentTimeMillis();
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
        Logger.v(TAG, "Tracker Session Object created.", new Object[0]);
    }

    private static synchronized String retrieveUserId(Context context, SessionState state) {
        String userId = state != null ? state.getUserId() : Util.getUUIDString();
        SharedPreferences generalPref = context.getSharedPreferences("snowplow_general_vars", 0);
        String storedUserId = generalPref.getString("SPInstallationUserId", null);
        if (storedUserId != null) {
            userId = storedUserId;
        } else {
            generalPref.edit().putString("SPInstallationUserId", userId).commit();
        }
        return userId;
    }

    @NonNull
    public synchronized SelfDescribingJson getSessionContext(@NonNull String eventId) {
        Logger.v(TAG, "Getting session context...", new Object[0]);
        if (this.isSessionCheckerEnabled) {
            if (this.shouldUpdateSession()) {
                Logger.d(TAG, "Update session information.", new Object[0]);
                this.updateSession(eventId);
                if (this.isBackground.get()) {
                    this.executeEventCallback(this.backgroundTimeoutCallback);
                } else {
                    this.executeEventCallback(this.foregroundTimeoutCallback);
                }
            }
            this.lastSessionCheck = System.currentTimeMillis();
        }
        return new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/client_session/jsonschema/1-0-1", this.state.getSessionValues());
    }

    private boolean shouldUpdateSession() {
        if (this.isNewSession.get()) {
            return true;
        }
        long now = System.currentTimeMillis();
        long timeout = this.isBackground.get() ? this.backgroundTimeout : this.foregroundTimeout;
        return now < this.lastSessionCheck || now - this.lastSessionCheck > timeout;
    }

    private synchronized void updateSession(String eventId) {
        this.isNewSession.set(false);
        String currentSessionId = Util.getUUIDString();
        int sessionIndex = 1;
        String previousSessionId = null;
        String storage = "LOCAL_STORAGE";
        if (this.state != null) {
            sessionIndex = this.state.getSessionIndex() + 1;
            previousSessionId = this.state.getSessionId();
            storage = this.state.getStorage();
        }
        this.state = new SessionState(eventId, currentSessionId, previousSessionId, sessionIndex, this.userId, storage);
        this.storeSessionState(this.state);
        this.callOnSessionUpdateCallback(this.state);
    }

    private void storeSessionState(SessionState state) {
        JSONObject jsonObject = new JSONObject(state.getSessionValues());
        String jsonString = jsonObject.toString();
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putString("session_state", jsonString);
        editor.apply();
    }

    private void callOnSessionUpdateCallback(final SessionState state) {
        if (this.onSessionUpdate != null) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Session.this.onSessionUpdate.accept((Object)state);
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
    }

    private void executeEventCallback(Runnable callback) {
        if (callback == null) {
            return;
        }
        try {
            callback.run();
        }
        catch (Exception e) {
            Logger.e(TAG, "Session event callback failed", new Object[0]);
        }
    }

    public void startNewSession() {
        this.isNewSession.set(true);
    }

    public void setBackground(boolean isBackground) {
        if (!this.isBackground.compareAndSet(!isBackground, isBackground)) {
            return;
        }
        if (!isBackground) {
            Logger.d(TAG, "Application moved to foreground", new Object[0]);
            this.executeEventCallback(this.foregroundTransitionCallback);
            try {
                this.setIsSuspended(false);
            }
            catch (Exception e) {
                Logger.e(TAG, "Could not resume checking as tracker not setup. Exception: %s", e);
            }
            ++this.foregroundIndex;
        } else {
            Logger.d(TAG, "Application moved to background", new Object[0]);
            this.executeEventCallback(this.backgroundTransitionCallback);
            ++this.backgroundIndex;
        }
    }

    public boolean isBackground() {
        return this.isBackground.get();
    }

    public void setIsSuspended(boolean isSuspended) {
        Logger.d(TAG, "Session is suspended: %s", isSuspended);
        this.isSessionCheckerEnabled = !isSuspended;
    }

    public int getBackgroundIndex() {
        return this.backgroundIndex;
    }

    public int getForegroundIndex() {
        return this.foregroundIndex;
    }

    @Nullable
    private Map<String, Object> getSessionMapFromLegacyTrackerV1(@NonNull Context context) {
        Map<String, Object> sessionMap = FileStore.getMapFromFile("snowplow_session_vars", context);
        sessionMap.put("firstEventId", "");
        sessionMap.put("previousSessionId", null);
        sessionMap.put("storageMechanism", "LOCAL_STORAGE");
        return sessionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<String, Object> getSessionMapFromLegacyTrackerV2(@NonNull Context context, @NonNull String sessionVarsName) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences(sessionVarsName, 0);
            if (!sharedPreferences.contains("sessionId") && !(sharedPreferences = context.getSharedPreferences("snowplow_session_vars", 0)).contains("sessionId")) {
                Map<String, Object> map = null;
                return map;
            }
            HashMap<String, Object> sessionMap = new HashMap<String, Object>();
            String sessionId = sharedPreferences.getString("sessionId", null);
            if (sessionId == null) {
                Map<String, Object> map = null;
                return map;
            }
            sessionMap.put("sessionId", sessionId);
            String userId = sharedPreferences.getString("userId", null);
            if (userId == null) {
                Map<String, Object> map = null;
                return map;
            }
            sessionMap.put("userId", userId);
            int sessionIndex = sharedPreferences.getInt("sessionIndex", 0);
            sessionMap.put("sessionIndex", sessionIndex);
            sessionMap.put("firstEventId", "");
            sessionMap.put("previousSessionId", null);
            sessionMap.put("storageMechanism", "LOCAL_STORAGE");
            HashMap<String, Object> hashMap = sessionMap;
            return hashMap;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<String, Object> getSessionMapFromLegacyTrackerV3(@NonNull Context context, @NonNull String sessionVarsName) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences(sessionVarsName, 0);
            if (!sharedPreferences.contains("session_state")) {
                Map<String, Object> map = null;
                return map;
            }
            HashMap<String, Object> sessionMap = new HashMap<String, Object>();
            String jsonString = sharedPreferences.getString("session_state", null);
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = jsonObject.get(key);
                sessionMap.put(key, value);
            }
            HashMap<String, Object> hashMap = sessionMap;
            return hashMap;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
        return null;
    }

    public int getSessionIndex() {
        return this.state.getSessionIndex();
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    @Nullable
    public SessionState getState() {
        return this.state;
    }

    public void setForegroundTimeout(long foregroundTimeout) {
        this.foregroundTimeout = foregroundTimeout;
    }

    public long getForegroundTimeout() {
        return this.foregroundTimeout;
    }

    public void setBackgroundTimeout(long backgroundTimeout) {
        this.backgroundTimeout = backgroundTimeout;
    }

    public long getBackgroundTimeout() {
        return this.backgroundTimeout;
    }
}

