/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.session;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import com.snowplowanalytics.snowplow.configuration.SessionConfiguration;
import com.snowplowanalytics.snowplow.tracker.SessionState;
import com.snowplowanalytics.snowplow.util.TimeMeasure;
import java.util.concurrent.TimeUnit;

public class SessionConfigurationUpdate
extends SessionConfiguration {
    @Nullable
    public SessionConfiguration sourceConfig;
    public boolean isPaused;
    public boolean foregroundTimeoutUpdated;
    public boolean backgroundTimeoutUpdated;

    public SessionConfigurationUpdate() {
        this(new TimeMeasure(30L, TimeUnit.MINUTES), new TimeMeasure(30L, TimeUnit.MINUTES));
    }

    public SessionConfigurationUpdate(@NonNull TimeMeasure foregroundTimeout, @NonNull TimeMeasure backgroundTimeout) {
        super(foregroundTimeout, backgroundTimeout);
    }

    @Override
    @Nullable
    public Consumer<SessionState> getOnSessionUpdate() {
        return this.sourceConfig == null ? null : this.sourceConfig.getOnSessionUpdate();
    }

    @Override
    @NonNull
    public TimeMeasure getForegroundTimeout() {
        return this.sourceConfig == null || this.foregroundTimeoutUpdated ? this.foregroundTimeout : this.sourceConfig.foregroundTimeout;
    }

    @Override
    @NonNull
    public TimeMeasure getBackgroundTimeout() {
        return this.sourceConfig == null || this.backgroundTimeoutUpdated ? this.backgroundTimeout : this.sourceConfig.backgroundTimeout;
    }
}

