/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.session;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Consumer;
import com.snowplowanalytics.snowplow.controller.SessionController;
import com.snowplowanalytics.snowplow.internal.Controller;
import com.snowplowanalytics.snowplow.internal.session.Session;
import com.snowplowanalytics.snowplow.internal.session.SessionConfigurationUpdate;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.tracker.ServiceProviderInterface;
import com.snowplowanalytics.snowplow.internal.tracker.Tracker;
import com.snowplowanalytics.snowplow.tracker.SessionState;
import com.snowplowanalytics.snowplow.util.TimeMeasure;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SessionControllerImpl
extends Controller
implements SessionController {
    private final String TAG = SessionControllerImpl.class.getName();

    public SessionControllerImpl(@NonNull ServiceProviderInterface serviceProvider) {
        super(serviceProvider);
    }

    @Override
    public void pause() {
        this.getDirtyConfig().isPaused = true;
        this.getTracker().pauseSessionChecking();
    }

    @Override
    public void resume() {
        this.getDirtyConfig().isPaused = false;
        this.getTracker().resumeSessionChecking();
    }

    @Override
    public void startNewSession() {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return;
        }
        session.startNewSession();
    }

    @Override
    public int getSessionIndex() {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return -1;
        }
        return session.getSessionIndex();
    }

    @Override
    @NonNull
    public String getSessionId() {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return "";
        }
        return session.getState().getSessionId();
    }

    @Override
    @NonNull
    public String getUserId() {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return "";
        }
        return session.getUserId();
    }

    @Override
    public boolean isInBackground() {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return false;
        }
        return session.isBackground();
    }

    @Override
    public int getBackgroundIndex() {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return -1;
        }
        return session.getBackgroundIndex();
    }

    @Override
    public int getForegroundIndex() {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return -1;
        }
        return session.getForegroundIndex();
    }

    @Override
    @NonNull
    public TimeMeasure getForegroundTimeout() {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return new TimeMeasure(0L, TimeUnit.SECONDS);
        }
        return new TimeMeasure(session.getForegroundTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void setForegroundTimeout(@NonNull TimeMeasure foregroundTimeout) {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return;
        }
        this.getDirtyConfig().foregroundTimeout = foregroundTimeout;
        this.getDirtyConfig().foregroundTimeoutUpdated = true;
        session.setForegroundTimeout(foregroundTimeout.convert(TimeUnit.MILLISECONDS));
    }

    @Override
    @NonNull
    public TimeMeasure getBackgroundTimeout() {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return new TimeMeasure(0L, TimeUnit.SECONDS);
        }
        return new TimeMeasure(session.getBackgroundTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void setBackgroundTimeout(@NonNull TimeMeasure backgroundTimeout) {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return;
        }
        this.getDirtyConfig().backgroundTimeout = backgroundTimeout;
        this.getDirtyConfig().backgroundTimeoutUpdated = true;
        session.setBackgroundTimeout(backgroundTimeout.convert(TimeUnit.MILLISECONDS));
    }

    @Override
    @Nullable
    public Consumer<SessionState> getOnSessionUpdate() {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return null;
        }
        return session.onSessionUpdate;
    }

    @Override
    public void setOnSessionUpdate(@Nullable Consumer<SessionState> onSessionUpdate) {
        Session session = this.getSession();
        if (session == null) {
            Logger.track(this.TAG, "Attempt to access SessionController fields when disabled", new Object[0]);
            return;
        }
        session.onSessionUpdate = onSessionUpdate;
    }

    public boolean isEnabled() {
        return this.getTracker().getSession() != null;
    }

    @NonNull
    private Tracker getTracker() {
        return this.serviceProvider.getTracker();
    }

    @Nullable
    private Session getSession() {
        return this.serviceProvider.getTracker().getSession();
    }

    @NonNull
    private SessionConfigurationUpdate getDirtyConfig() {
        return this.serviceProvider.getSessionConfigurationUpdate();
    }
}

