/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.event.ScreenView;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.utils.NotificationCenter;
import java.util.HashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@TargetApi(value=14)
public class ActivityLifecycleHandler
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = ActivityLifecycleHandler.class.getSimpleName();
    private static ActivityLifecycleHandler sharedInstance;

    @NonNull
    public static synchronized ActivityLifecycleHandler getInstance(@NonNull Context context) {
        if (sharedInstance == null) {
            sharedInstance = new ActivityLifecycleHandler(context);
        }
        return sharedInstance;
    }

    private ActivityLifecycleHandler(@NonNull Context context) {
        Application application = (Application)context.getApplicationContext();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
    }

    public void onActivityStarted(@NonNull Activity activity) {
    }

    public void onActivityResumed(@NonNull Activity activity) {
        Logger.d(TAG, "Auto screenview occurred - activity has resumed", new Object[0]);
        try {
            ScreenView event = ScreenView.buildWithActivity(activity);
            HashMap<String, Object> notificationData = new HashMap<String, Object>();
            notificationData.put("event", event);
            NotificationCenter.postNotification("SnowplowScreenView", notificationData);
        }
        catch (Exception e) {
            Logger.e(TAG, "Method onActivityResumed raised an exception: %s", e);
        }
    }

    public void onActivityPaused(@NonNull Activity activity) {
    }

    public void onActivityStopped(@NonNull Activity activity) {
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @Nullable Bundle outState) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
    }
}

