/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.entity.DeepLink;
import com.snowplowanalytics.snowplow.event.DeepLinkReceived;
import com.snowplowanalytics.snowplow.event.Event;
import com.snowplowanalytics.snowplow.internal.tracker.DeepLinkState;
import com.snowplowanalytics.snowplow.internal.tracker.State;
import com.snowplowanalytics.snowplow.internal.tracker.StateMachineInterface;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.InspectableEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DeepLinkStateMachine
implements StateMachineInterface {
    @Override
    @NonNull
    public List<String> subscribedEventSchemasForTransitions() {
        return Arrays.asList("iglu:com.snowplowanalytics.mobile/deep_link_received/jsonschema/1-0-0", "iglu:com.snowplowanalytics.mobile/screen_view/jsonschema/1-0-0");
    }

    @Override
    @NonNull
    public List<String> subscribedEventSchemasForEntitiesGeneration() {
        return Arrays.asList("iglu:com.snowplowanalytics.mobile/screen_view/jsonschema/1-0-0");
    }

    @Override
    @NonNull
    public List<String> subscribedEventSchemasForPayloadUpdating() {
        return new ArrayList<String>();
    }

    @Override
    @Nullable
    public State transition(@NonNull Event event, @Nullable State state) {
        if (event instanceof DeepLinkReceived) {
            DeepLinkReceived dlEvent = (DeepLinkReceived)event;
            return new DeepLinkState(dlEvent.url, dlEvent.referrer);
        }
        if (state == null) {
            return null;
        }
        DeepLinkState dlState = (DeepLinkState)state;
        if (dlState.readyForOutput) {
            return null;
        }
        DeepLinkState currentState = new DeepLinkState(dlState.url, dlState.referrer);
        currentState.readyForOutput = true;
        return currentState;
    }

    @Override
    @Nullable
    public List<SelfDescribingJson> entities(@NonNull InspectableEvent event, @Nullable State state) {
        if (state == null) {
            return null;
        }
        DeepLinkState deepLinkState = (DeepLinkState)state;
        if (!deepLinkState.readyForOutput) {
            return null;
        }
        DeepLink entity = new DeepLink(deepLinkState.url).referrer(deepLinkState.referrer);
        return Collections.singletonList(entity);
    }

    @Override
    @Nullable
    public Map<String, Object> payloadValues(@NonNull InspectableEvent event, @Nullable State state) {
        return null;
    }
}

