/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.event.SelfDescribing;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.utils.NotificationCenter;
import com.snowplowanalytics.snowplow.internal.utils.Util;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.HashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = ExceptionHandler.class.getSimpleName();
    private static final int MAX_MESSAGE_LENGTH = 2048;
    private static final int MAX_STACK_LENGTH = 8096;
    private static final int MAX_THREAD_NAME_LENGTH = 1024;
    private static final int MAX_CLASS_NAME_LENGTH = 1024;
    private static final int MAX_EXCEPTION_NAME_LENGTH = 1024;
    private final Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();

    @Override
    public void uncaughtException(@NonNull Thread t, Throwable e) {
        Logger.d(TAG, "Uncaught exception being tracked...", new Object[0]);
        String message = this.truncateString(e.getMessage(), 2048);
        if (message == null || message.isEmpty()) {
            message = "Android Exception. Null or empty message found";
        }
        String stack = this.truncateString(Util.stackTraceToString(e), 8096);
        String threadName = this.truncateString(t.getName(), 1024);
        Integer lineNumber = null;
        String className = null;
        if (e.getStackTrace().length > 0) {
            StackTraceElement stackElement = e.getStackTrace()[0];
            lineNumber = stackElement.getLineNumber();
            if (lineNumber < 0) {
                lineNumber = null;
            }
            className = this.truncateString(stackElement.getClassName(), 1024);
        }
        String exceptionName = this.truncateString(e.getClass().getName(), 1024);
        HashMap<String, Object> data = new HashMap<String, Object>();
        Util.addToMap("message", message, data);
        Util.addToMap("stackTrace", stack, data);
        Util.addToMap("threadName", threadName, data);
        Util.addToMap("threadId", t.getId(), data);
        Util.addToMap("programmingLanguage", "JAVA", data);
        Util.addToMap("lineNumber", lineNumber, data);
        Util.addToMap("className", className, data);
        Util.addToMap("exceptionName", exceptionName, data);
        Util.addToMap("isFatal", true, data);
        SelfDescribing event = new SelfDescribing(new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/application_error/jsonschema/1-0-0", data));
        HashMap<String, Object> notificationData = new HashMap<String, Object>();
        notificationData.put("event", event);
        NotificationCenter.postNotification("SnowplowCrashReporting", notificationData);
        this.defaultHandler.uncaughtException(t, e);
    }

    private String truncateString(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        return str.substring(0, Math.min(str.length(), maxLength));
    }
}

