/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.event.SelfDescribing;
import com.snowplowanalytics.snowplow.internal.utils.NotificationCenter;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.Calendar;
import java.util.HashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class InstallTracker {
    private static String TAG = InstallTracker.class.getSimpleName();
    private Boolean isNewInstall;
    private SharedPreferences sharedPreferences;
    private static InstallTracker sharedInstance;

    @NonNull
    public static synchronized InstallTracker getInstance(@NonNull Context context) {
        if (sharedInstance == null) {
            sharedInstance = new InstallTracker(context);
        }
        return sharedInstance;
    }

    private InstallTracker(@NonNull Context context) {
        new SharedPreferencesTask().execute(new Context[]{context});
    }

    private void sendInstallEvent(long installTimestamp) {
        SelfDescribing event = new SelfDescribing(new SelfDescribingJson("iglu:com.snowplowanalytics.mobile/application_install/jsonschema/1-0-0"));
        if (installTimestamp > 0L) {
            event.trueTimestamp(installTimestamp);
        }
        HashMap<String, Object> notificationData = new HashMap<String, Object>();
        notificationData.put("event", event);
        NotificationCenter.postNotification("SnowplowInstallTracking", notificationData);
    }

    private class SharedPreferencesTask
    extends AsyncTask<Context, Void, Boolean> {
        private SharedPreferencesTask() {
        }

        protected Boolean doInBackground(Context ... contexts) {
            InstallTracker.this.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)contexts[0]);
            if (InstallTracker.this.sharedPreferences.getString("installed_before", null) == null) {
                SharedPreferences.Editor editor = InstallTracker.this.sharedPreferences.edit();
                editor.putString("installed_before", "YES");
                editor.putLong("install_timestamp", Calendar.getInstance().getTimeInMillis());
                editor.apply();
                InstallTracker.this.isNewInstall = true;
            } else {
                InstallTracker.this.isNewInstall = false;
            }
            return InstallTracker.this.isNewInstall;
        }

        protected void onPostExecute(Boolean isNewInstall) {
            long installTimestamp = InstallTracker.this.sharedPreferences.getLong("install_timestamp", 0L);
            if (!isNewInstall.booleanValue() && installTimestamp <= 0L) {
                return;
            }
            InstallTracker.this.sendInstallEvent(installTimestamp);
            SharedPreferences.Editor editor = InstallTracker.this.sharedPreferences.edit();
            editor.remove("install_timestamp");
            editor.commit();
        }
    }
}

