/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.entity.LifecycleEntity;
import com.snowplowanalytics.snowplow.event.Background;
import com.snowplowanalytics.snowplow.event.Event;
import com.snowplowanalytics.snowplow.event.Foreground;
import com.snowplowanalytics.snowplow.internal.tracker.LifecycleState;
import com.snowplowanalytics.snowplow.internal.tracker.State;
import com.snowplowanalytics.snowplow.internal.tracker.StateMachineInterface;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.InspectableEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LifecycleStateMachine
implements StateMachineInterface {
    @Override
    @NonNull
    public List<String> subscribedEventSchemasForTransitions() {
        return Arrays.asList("iglu:com.snowplowanalytics.snowplow/application_background/jsonschema/1-0-0", "iglu:com.snowplowanalytics.snowplow/application_foreground/jsonschema/1-0-0");
    }

    @Override
    @NonNull
    public List<String> subscribedEventSchemasForEntitiesGeneration() {
        return Collections.singletonList("*");
    }

    @Override
    @NonNull
    public List<String> subscribedEventSchemasForPayloadUpdating() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public State transition(@NonNull Event event, @Nullable State currentState) {
        if (event instanceof Foreground) {
            Foreground e = (Foreground)event;
            return new LifecycleState(true, e.foregroundIndex);
        }
        if (event instanceof Background) {
            Background e = (Background)event;
            return new LifecycleState(false, e.backgroundIndex);
        }
        return null;
    }

    @Override
    @Nullable
    public List<SelfDescribingJson> entities(@NonNull InspectableEvent event, @Nullable State state) {
        if (state == null) {
            return null;
        }
        LifecycleState s = (LifecycleState)state;
        return Collections.singletonList(new LifecycleEntity(s.isForeground).index(s.index));
    }

    @Override
    @Nullable
    public Map<String, Object> payloadValues(@NonNull InspectableEvent event, @Nullable State state) {
        return null;
    }
}

