/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.event.TrackerError;
import com.snowplowanalytics.snowplow.internal.tracker.DefaultLoggerDelegate;
import com.snowplowanalytics.snowplow.internal.utils.NotificationCenter;
import com.snowplowanalytics.snowplow.tracker.LogLevel;
import com.snowplowanalytics.snowplow.tracker.LoggerDelegate;
import java.util.HashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class Logger {
    private static final String TAG = Logger.class.getSimpleName();
    private static LoggerDelegate delegate = new DefaultLoggerDelegate();
    private static int level = 0;

    public static void updateLogLevel(@NonNull LogLevel newLevel) {
        level = newLevel.getLevel();
    }

    public static void setDelegate(@Nullable LoggerDelegate delegate) {
        Logger.delegate = delegate != null ? delegate : new DefaultLoggerDelegate();
    }

    @Nullable
    public static LoggerDelegate getDelegate() {
        return delegate;
    }

    public static void track(@NonNull String tag, @NonNull String msg, Object ... args) {
        Logger.e(tag, msg, args);
        try {
            Throwable throwable = null;
            for (Object arg : args) {
                if (!Throwable.class.isInstance(arg)) continue;
                throwable = (Throwable)arg;
                break;
            }
            TrackerError event = new TrackerError(tag, Logger.getMessage(msg, args), throwable);
            HashMap<String, Object> notificationData = new HashMap<String, Object>();
            notificationData.put("event", event);
            NotificationCenter.postNotification("SnowplowTrackerDiagnostic", notificationData);
        }
        catch (Exception e) {
            Logger.v(TAG, "Error logger can't report the error: " + e, new Object[0]);
        }
    }

    public static void e(@NonNull String tag, @NonNull String msg, Object ... args) {
        if (level >= 1) {
            String source = Logger.getTag(tag);
            String message = Logger.getMessage(msg, args);
            delegate.error(source, message);
        }
    }

    public static void d(@NonNull String tag, @NonNull String msg, Object ... args) {
        if (level >= 2) {
            String source = Logger.getTag(tag);
            String message = Logger.getMessage(msg, args);
            delegate.debug(source, message);
        }
    }

    public static void v(@NonNull String tag, @NonNull String msg, Object ... args) {
        if (level >= 3) {
            String source = Logger.getTag(tag);
            String message = Logger.getMessage(msg, args);
            delegate.verbose(source, message);
        }
    }

    @NonNull
    private static String getMessage(@NonNull String msg, Object ... args) {
        return Logger.getThread() + "|" + String.format(msg, args);
    }

    @NonNull
    private static String getTag(@NonNull String tag) {
        return "SnowplowTracker->" + tag;
    }

    @NonNull
    private static String getThread() {
        return Thread.currentThread().getName();
    }
}

