/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import android.content.Context;
import android.net.NetworkInfo;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.internal.utils.DeviceInfoMonitor;
import com.snowplowanalytics.snowplow.internal.utils.Util;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.HashMap;
import java.util.Map;

public class PlatformContext {
    private final Map<String, Object> pairs = new HashMap<String, Object>();
    @NonNull
    private final DeviceInfoMonitor deviceInfoMonitor;
    @NonNull
    private final Context context;
    private long lastUpdatedEphemeralPlatformDict;
    private long lastUpdatedEphemeralNetworkDict;
    private final long platformDictUpdateFrequency;
    private final long networkDictUpdateFrequency;

    PlatformContext(long platformDictUpdateFrequency, long networkDictUpdateFrequency, @NonNull DeviceInfoMonitor deviceInfoMonitor, @NonNull Context context) {
        this.platformDictUpdateFrequency = platformDictUpdateFrequency;
        this.networkDictUpdateFrequency = networkDictUpdateFrequency;
        this.deviceInfoMonitor = deviceInfoMonitor;
        this.context = context;
        this.setPlatformDict();
    }

    PlatformContext(@NonNull Context context) {
        this(100L, 10000L, new DeviceInfoMonitor(), context);
    }

    @Nullable
    public SelfDescribingJson getMobileContext() {
        this.updateEphemeralDictsIfNecessary();
        if (Util.mapHasKeys(this.pairs, "osType", "osVersion", "deviceManufacturer", "deviceModel")) {
            return new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/mobile_context/jsonschema/1-0-2", this.pairs);
        }
        return null;
    }

    private synchronized void updateEphemeralDictsIfNecessary() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdatedEphemeralPlatformDict >= this.platformDictUpdateFrequency) {
            this.setEphemeralPlatformDict();
        }
        if (now - this.lastUpdatedEphemeralNetworkDict >= this.networkDictUpdateFrequency) {
            this.setEphemeralNetworkDict();
        }
    }

    private void setPlatformDict() {
        Util.addToMap("osType", this.deviceInfoMonitor.getOsType(), this.pairs);
        Util.addToMap("osVersion", this.deviceInfoMonitor.getOsVersion(), this.pairs);
        Util.addToMap("deviceModel", this.deviceInfoMonitor.getDeviceModel(), this.pairs);
        Util.addToMap("deviceManufacturer", this.deviceInfoMonitor.getDeviceVendor(), this.pairs);
        Util.addToMap("carrier", this.deviceInfoMonitor.getCarrier(this.context), this.pairs);
        Util.addToMap("physicalMemory", this.deviceInfoMonitor.getPhysicalMemory(this.context), this.pairs);
        Util.addToMap("totalStorage", this.deviceInfoMonitor.getTotalStorage(), this.pairs);
        this.setEphemeralPlatformDict();
        this.setEphemeralNetworkDict();
    }

    private void setEphemeralPlatformDict() {
        Pair<String, Integer> batteryInfo;
        this.lastUpdatedEphemeralPlatformDict = System.currentTimeMillis();
        Object currentIdfa = this.pairs.get("androidIdfa");
        if (currentIdfa == null || currentIdfa.toString().isEmpty()) {
            Util.addToMap("androidIdfa", this.deviceInfoMonitor.getAndroidIdfa(this.context), this.pairs);
        }
        if ((batteryInfo = this.deviceInfoMonitor.getBatteryStateAndLevel(this.context)) != null) {
            Util.addToMap("batteryState", batteryInfo.first, this.pairs);
            Util.addToMap("batteryLevel", batteryInfo.second, this.pairs);
        }
        Util.addToMap("systemAvailableMemory", this.deviceInfoMonitor.getSystemAvailableMemory(this.context), this.pairs);
        Util.addToMap("availableStorage", this.deviceInfoMonitor.getAvailableStorage(), this.pairs);
    }

    private void setEphemeralNetworkDict() {
        this.lastUpdatedEphemeralNetworkDict = System.currentTimeMillis();
        NetworkInfo networkInfo = this.deviceInfoMonitor.getNetworkInfo(this.context);
        Util.addToMap("networkTechnology", this.deviceInfoMonitor.getNetworkTechnology(networkInfo), this.pairs);
        Util.addToMap("networkType", this.deviceInfoMonitor.getNetworkType(networkInfo), this.pairs);
    }
}

