/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SchemaRule {
    private static final String RULE_PATTERN = "^iglu:((?:(?:[a-zA-Z0-9-_]+|\\*)\\.)+(?:[a-zA-Z0-9-_]+|\\*))\\/([a-zA-Z0-9-_\\.]+|\\*)\\/([a-zA-Z0-9-_\\.]+|\\*)\\/([1-9][0-9]*|\\*)-(0|[1-9][0-9]*|\\*)-(0|[1-9][0-9]*|\\*)$";
    private static final String URI_PATTERN = "^iglu:((?:(?:[a-zA-Z0-9-_]+)\\.)+(?:[a-zA-Z0-9-_]+))\\/([a-zA-Z0-9-_]+)\\/([a-zA-Z0-9-_]+)\\/([1-9][0-9]*)\\-(0|[1-9][0-9]*)\\-(0|[1-9][0-9]*)$";
    private final String rule;
    private final List<String> ruleParts;

    private SchemaRule(@NonNull String rule, @NonNull List<String> ruleParts) {
        this.rule = rule;
        this.ruleParts = ruleParts;
    }

    @Nullable
    public static SchemaRule build(@NonNull String rule) {
        if (rule == null || rule.isEmpty()) {
            return null;
        }
        List<String> parts = SchemaRule.getParts(rule, RULE_PATTERN);
        if (parts == null || parts.isEmpty() || !SchemaRule.validateVendor(parts.get(0))) {
            return null;
        }
        return new SchemaRule(rule, parts);
    }

    @NonNull
    public String getRule() {
        return this.rule;
    }

    public boolean matchWithSchema(@NonNull String schema) {
        if (schema == null) {
            return false;
        }
        List<String> uriParts = SchemaRule.getParts(schema, URI_PATTERN);
        if (uriParts == null || uriParts.size() < this.ruleParts.size()) {
            return false;
        }
        String[] ruleVendor = this.ruleParts.get(0).split("\\.");
        String[] uriVendor = uriParts.get(0).split("\\.");
        if (uriVendor.length != ruleVendor.length) {
            return false;
        }
        int index = 0;
        for (String ruleVendorPart : ruleVendor) {
            if (!"*".equals(ruleVendorPart) && !uriVendor[index].equals(ruleVendorPart)) {
                return false;
            }
            ++index;
        }
        index = 1;
        for (String rulePart : this.ruleParts.subList(1, this.ruleParts.size())) {
            if (!"*".equals(rulePart) && !uriParts.get(index).equals(rulePart)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Nullable
    private static List<String> getParts(@NonNull String uri, @NonNull String regex) {
        ArrayList<String> result = new ArrayList<String>(6);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(uri);
        if (!matcher.find()) {
            return null;
        }
        for (int i = 1; i < matcher.groupCount(); ++i) {
            if (i > 6) {
                return null;
            }
            String part = matcher.group(i);
            result.add(part);
        }
        return result;
    }

    private static boolean validateVendor(@NonNull String vendor) {
        String[] components = vendor.split("\\.");
        if (components.length > 1 && (components[0].isEmpty() || components[components.length - 1].isEmpty())) {
            return false;
        }
        if ("*".equals(components[0]) || "*".equals(components[1])) {
            return false;
        }
        if (components.length <= 2) {
            return true;
        }
        String[] trailingComponents = Arrays.copyOfRange(components, 2, components.length);
        boolean asterisk = false;
        for (String part : trailingComponents) {
            if ("*".equals(part)) {
                asterisk = true;
                continue;
            }
            if (!asterisk) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRule that = (SchemaRule)o;
        return this.rule.equals(that.rule);
    }

    public int hashCode() {
        return this.rule.hashCode();
    }
}

