/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.internal.tracker.State;
import com.snowplowanalytics.snowplow.internal.utils.Util;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.payload.TrackerPayload;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ScreenState
implements State {
    private String name = "Unknown";
    private String type;
    private String id = Util.getUUIDString();
    private String previousName;
    private String previousId;
    private String previousType;
    private String transitionType;
    private String fragmentClassName;
    private String fragmentTag;
    private String activityClassName;
    private String activityTag;

    @Nullable
    public String getPreviousId() {
        return this.previousId;
    }

    @Nullable
    public String getPreviousName() {
        return this.previousName;
    }

    @Nullable
    public String getPreviousType() {
        return this.previousType;
    }

    public synchronized void updateScreenState(@NonNull String id, @NonNull String name, @Nullable String type, @Nullable String transitionType) {
        this.populatePreviousFields();
        this.name = name;
        this.type = type;
        this.transitionType = transitionType;
        this.id = id != null ? id : Util.getUUIDString();
    }

    public synchronized void updateScreenState(@NonNull String id, @NonNull String name, @Nullable String type, @Nullable String transitionType, @Nullable String fragmentClassName, @Nullable String fragmentTag, @Nullable String activityClassName, @Nullable String activityTag) {
        this.updateScreenState(id, name, type, transitionType);
        this.fragmentClassName = fragmentClassName;
        this.fragmentTag = fragmentTag;
        this.activityClassName = activityClassName;
        this.activityTag = activityTag;
    }

    public void populatePreviousFields() {
        this.previousName = this.name;
        this.previousType = this.type;
        this.previousId = this.id;
    }

    @NonNull
    public SelfDescribingJson getCurrentScreen(boolean debug) {
        TrackerPayload contextPayload = new TrackerPayload();
        contextPayload.add("id", this.id);
        contextPayload.add("name", this.name);
        contextPayload.add("type", this.type);
        if (debug) {
            contextPayload.add("fragment", this.getValidName(this.fragmentClassName, this.fragmentTag));
            contextPayload.add("activity", this.getValidName(this.activityClassName, this.activityTag));
        }
        return new SelfDescribingJson("iglu:com.snowplowanalytics.mobile/screen/jsonschema/1-0-0", contextPayload);
    }

    private String getValidName(String s1, String s2) {
        if (s1 != null && s1.length() > 0) {
            return s1;
        }
        if (s2 != null && s2.length() > 0) {
            return s2;
        }
        return null;
    }
}

