/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.Event;
import com.snowplowanalytics.snowplow.event.ScreenView;
import com.snowplowanalytics.snowplow.internal.tracker.ScreenState;
import com.snowplowanalytics.snowplow.internal.tracker.State;
import com.snowplowanalytics.snowplow.internal.tracker.StateMachineInterface;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.InspectableEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScreenStateMachine
implements StateMachineInterface {
    @Override
    @NonNull
    public List<String> subscribedEventSchemasForTransitions() {
        return Collections.singletonList("iglu:com.snowplowanalytics.mobile/screen_view/jsonschema/1-0-0");
    }

    @Override
    @NonNull
    public List<String> subscribedEventSchemasForEntitiesGeneration() {
        return Collections.singletonList("*");
    }

    @Override
    @NonNull
    public List<String> subscribedEventSchemasForPayloadUpdating() {
        return Collections.singletonList("iglu:com.snowplowanalytics.mobile/screen_view/jsonschema/1-0-0");
    }

    @Override
    @Nullable
    public State transition(@NonNull Event event, @Nullable State state) {
        ScreenView screenView = (ScreenView)event;
        ScreenState screenState = state != null ? (ScreenState)state : new ScreenState();
        screenState.updateScreenState(screenView.id, screenView.name, screenView.type, screenView.transitionType, screenView.fragmentClassName, screenView.fragmentTag, screenView.activityClassName, screenView.activityTag);
        return screenState;
    }

    @Override
    @NonNull
    public List<SelfDescribingJson> entities(@NonNull InspectableEvent event, @Nullable State state) {
        if (state == null) {
            return new ArrayList<SelfDescribingJson>();
        }
        ScreenState screenState = (ScreenState)state;
        SelfDescribingJson entity = screenState.getCurrentScreen(true);
        return Collections.singletonList(entity);
    }

    @Override
    @Nullable
    public Map<String, Object> payloadValues(@NonNull InspectableEvent event, @Nullable State state) {
        if (state instanceof ScreenState) {
            ScreenState screenState = (ScreenState)state;
            HashMap<String, Object> addedValues = new HashMap<String, Object>();
            String value = screenState.getPreviousName();
            if (value != null && !value.isEmpty()) {
                addedValues.put("previousName", value);
            }
            if ((value = screenState.getPreviousId()) != null && !value.isEmpty()) {
                addedValues.put("previousId", value);
            }
            if ((value = screenState.getPreviousType()) != null && !value.isEmpty()) {
                addedValues.put("previousType", value);
            }
            return addedValues;
        }
        return null;
    }
}

